//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// WinRootHandler.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
// WinRootHandler.h defines WinRootHandler class.
// The WinRootHandler class is a RRRootHandler which is specialized for
// converting window message of Windows into RREvent. 
//
//-------------------------------------------------------------------=72

#ifndef _WIN_ROOT_HANDLER_H
#define _WIN_ROOT_HANDLER_H

#include <afxwin.h>         // MFC core and standard components

#include "RRDef.h"
#include "RRRootHandler.h"

class WinRootHandler : public RRRootHandler
{
  protected:
  
  	virtual RRStatus mfMakeEvent(const void *e){return RR_SUCCESS;}
  	// mfMakeEvent() of WinRootHandler actually do nothing.
	// onXXX() functions are implemented instead of mfMakeEvent().

  	void mfSetEventPosition(
			const CWnd *wnd,
			const CPoint& p,
			RREvent& e)const;
	void mfSetEventModifier(
			const UINT nFlags,
			RREvent& e)const;

  public:
  	  	  
  	WinRootHandler();
   	WinRootHandler(const WinRootHandler& x); 	
  	virtual ~WinRootHandler();
  	
  	const WinRootHandler& operator=(const WinRootHandler& x);

	void onLButtonDown(
			const CWnd *wnd,
			const UINT nFlags, 
			const CPoint point); 
	void onLButtonUp(
			const CWnd *wnd,
			const UINT nFlags, 
			const CPoint point); 
	void onRButtonDown(
			const CWnd *wnd,
			const UINT nFlags, 
			const CPoint point); 
	void onRButtonUp(
			const CWnd *wnd,
			const UINT nFlags, 
			const CPoint point); 
	void onMouseMove(
			const CWnd *wnd,
			const UINT nFlags, 
			const CPoint point);
};
    
#endif // _WIN_ROOT_HANDLER_H

//-------------------------------------------------------------------=72
// End of WinRootHandler.h
//-------------------------------------------------------------------=72
