//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// WinRootHandler.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#define _WIN_ROOT_HANDLER_C

//#include "stdafx.h"

#include "WinRootHandler.h"

WinRootHandler::WinRootHandler()
:RRRootHandler()
{}

WinRootHandler::WinRootHandler(
			const WinRootHandler& x)
:RRRootHandler(x)
{}
	
WinRootHandler::~WinRootHandler()
{}
  	
const WinRootHandler& WinRootHandler::operator=(
			const WinRootHandler& x)
{
	RRRootHandler::operator=(x);
	return *this;
}

void WinRootHandler::mfSetEventPosition(
			const CWnd *wnd,
			const CPoint& p,
			RREvent& e)const
{
	CRect clntsize;
	wnd->GetClientRect(&clntsize);
	e.pos.setX(p.x);
	e.pos.setY(clntsize.Height()-p.y-1);
}

void WinRootHandler::mfSetEventModifier(
			const UINT nFlags,
			RREvent& e)const
{
	if(nFlags&MK_SHIFT)
		e.mod=RREVENT_MOD_SHIFT;
	else if(nFlags&MK_CONTROL)
		e.mod=RREVENT_MOD_CTRL;
	else
		e.mod=RREVENT_MOD_NONE;
}

void WinRootHandler::onLButtonDown(
			const CWnd *wnd,
			const UINT nFlags, 
			const CPoint point)
{
	mEventCache = new RREvent;

	mEventCache->type=RREVENT_PUSH_LBUTTON;
	mfSetEventPosition(wnd,point,*mEventCache);
	mfSetEventModifier(nFlags,*mEventCache);

	RRStatus status=RREventHandler::handleEvent(*mEventCache); 
	delete mEventCache;
	mEventCache=NULL;
}

void WinRootHandler::onLButtonUp(
			const CWnd *wnd,
			const UINT nFlags, 
			const CPoint point)
{
	mEventCache = new RREvent;

	mEventCache->type=RREVENT_RELEASE_LBUTTON;
	mfSetEventPosition(wnd,point,*mEventCache);
	mfSetEventModifier(nFlags,*mEventCache);

	RRStatus status=RREventHandler::handleEvent(*mEventCache); 
	delete mEventCache;
	mEventCache=NULL;
}

void WinRootHandler::onRButtonDown(
			const CWnd *wnd,
			const UINT nFlags, 
			const CPoint point)
{
	mEventCache = new RREvent;

	mEventCache->type=RREVENT_PUSH_RBUTTON;
	mfSetEventPosition(wnd,point,*mEventCache);
	mfSetEventModifier(nFlags,*mEventCache);

	RRStatus status=RREventHandler::handleEvent(*mEventCache); 
	delete mEventCache;
	mEventCache=NULL;
}
 
void WinRootHandler::onRButtonUp(
			const CWnd *wnd,
			const UINT nFlags, 
			const CPoint point)
{
	mEventCache = new RREvent;

	mEventCache->type=RREVENT_RELEASE_RBUTTON;
	mfSetEventPosition(wnd,point,*mEventCache);
	mfSetEventModifier(nFlags,*mEventCache);

	RRStatus status=RREventHandler::handleEvent(*mEventCache); 
	delete mEventCache;
	mEventCache=NULL;
}


void WinRootHandler::onMouseMove(
			const CWnd *wnd,
			const UINT nFlags, 
			const CPoint point)
{
	mEventCache = new RREvent;

	mEventCache->type=RREVENT_MOTION_NOTIFY;
	mfSetEventPosition(wnd,point,*mEventCache);
	mfSetEventModifier(nFlags,*mEventCache);

	RRStatus status=RREventHandler::handleEvent(*mEventCache); 
	delete mEventCache;
	mEventCache=NULL;
}
    
//-------------------------------------------------------------------=72
// End of WinRootHandler.cpp
//-------------------------------------------------------------------=72
