//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// WGLWindow.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72


#ifndef _WGL_WINDOW_H
#define _WGL_WINDOW_H

#include <afxwin.h>         // MFC core and standard components
#include <gl\gl.h>
#include <gl\glu.h>

#include "RRDef.h"
#include "WGLObject.h"

class WGLWindow
{
  private:

	static PIXELFORMATDESCRIPTOR pfd;
	
	HWND m_hWnd;
	HGLRC m_hRC;	// Rendering Context
	HDC m_hDC;		// Device Context
	CPalette m_GLPalette;	// Logical Palette

  public:

	WGLWindow(HWND hWnd);
	WGLWindow(const WGLWindow& x);
	~WGLWindow();

	const WGLWindow& operator=(const WGLWindow& x);

	BOOL hasPalette(){return (HPALETTE(m_GLPalette)==NULL)?FALSE:TRUE;}

	void InitializePalette(void);
	void MakeCurrent();
	void SwapBuffers();
	int UpdatePalette();
	void UpdateColors();

	void setViewport(const RECT& rect)const;
};

#endif // _WGL_WINDOW_H

//-------------------------------------------------------------------=72
// End of WGLWindow.h
//-------------------------------------------------------------------=72
