//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// WGLWindow.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72

//#include "stdafx.h"

#include "WGLWindow.h"

PIXELFORMATDESCRIPTOR WGLWindow::pfd = {
		sizeof(PIXELFORMATDESCRIPTOR),	// Size of this structure
		1,								// Version of this structure	
		PFD_DRAW_TO_WINDOW |			// Draw to Window (not to bitmap)
		PFD_SUPPORT_OPENGL |			// Support OpenGL calls in window
		PFD_DOUBLEBUFFER,				// Double buffered mode
		PFD_TYPE_RGBA,					// RGBA Color mode
		24,								// Want 24bit color 
		0,0,0,0,0,0,					// Not used to select mode
		0,0,							// Not used to select mode
		0,0,0,0,0,						// Not used to select mode
		32,								// Size of depth buffer
		0,								// Not used to select mode
		0,								// Not used to select mode
		PFD_MAIN_PLANE,					// Draw in main plane
		0,								// Not used to select mode
		0,0,0 };						// Not used to select mode


WGLWindow::WGLWindow(HWND hWnd)
:m_hWnd(hWnd)
{
	m_hDC = ::GetDC(m_hWnd);		

	int nPixelFormat=ChoosePixelFormat(m_hDC,&pfd);
	VERIFY(SetPixelFormat(m_hDC,nPixelFormat,&pfd));

	m_hRC=wglCreateContext(m_hDC);
	VERIFY(wglMakeCurrent(m_hDC,m_hRC));

	InitializePalette();
}

WGLWindow::WGLWindow(const WGLWindow& x)
:m_hWnd(x.m_hWnd),
 m_hRC(x.m_hRC),
 m_hDC(x.m_hDC)
{
	// m_GLPalette cannot be copied.
}

WGLWindow::~WGLWindow()
{
	wglMakeCurrent(NULL,NULL);
	wglDeleteContext(m_hRC);
	::ReleaseDC(m_hWnd,m_hDC);
}

const WGLWindow& WGLWindow::operator=(const WGLWindow& x)
{
	m_hWnd=x.m_hWnd;
	m_hRC=x.m_hRC;
	m_hDC=x.m_hDC;	
	// m_GLPalette cannot be copied.
	return *this;
}

// Initializes the CPalette object
void WGLWindow::InitializePalette(void)
{
	int nPixelFormat=GetPixelFormat(m_hDC);
	DescribePixelFormat(m_hDC,nPixelFormat,sizeof(PIXELFORMATDESCRIPTOR),&pfd);
	if(!(pfd.dwFlags & PFD_NEED_PALETTE))
		return;

	int nColors= 1 << pfd.cColorBits;	
	LOGPALETTE *pPal = (LOGPALETTE*)malloc(sizeof(LOGPALETTE)+nColors*sizeof(PALETTEENTRY));
	pPal->palVersion=0x300;		// Windows 3.0
	pPal->palNumEntries=nColors; // table size

	// Build mask of all 1's.  This creates a number represented by having
	// the low order x bits set, where x = pfd.cRedBits, pfd.cGreenBits, and
	// pfd.cBlueBits.  
	BYTE RedRange=(1<<pfd.cRedBits)-1;
	BYTE GreenRange=(1<<pfd.cGreenBits)-1;
	BYTE BlueRange=(1<<pfd.cBlueBits)-1;

	// Loop through all the palette entries
	for(int i=0;i<nColors;i++)
	{
		pPal->palPalEntry[i].peRed=(i>>pfd.cRedShift)&RedRange;
		pPal->palPalEntry[i].peRed=(unsigned char)(
			(double)pPal->palPalEntry[i].peRed*255.0/RedRange);

		pPal->palPalEntry[i].peGreen=(i>>pfd.cGreenShift)&GreenRange;
		pPal->palPalEntry[i].peGreen=(unsigned char)(
			(double)pPal->palPalEntry[i].peGreen*255.0/GreenRange);

		pPal->palPalEntry[i].peBlue=(i>>pfd.cBlueShift)&BlueRange;
		pPal->palPalEntry[i].peBlue=(unsigned char)(
			(double)pPal->palPalEntry[i].peBlue*255.0/BlueRange);

		pPal->palPalEntry[i].peFlags=(unsigned char)NULL;
	}
	m_GLPalette.CreatePalette(pPal);
	free(pPal);

	SelectPalette(m_hDC,(HPALETTE)m_GLPalette,FALSE);
	RealizePalette(m_hDC);
}

void WGLWindow::MakeCurrent()
{	
	wglMakeCurrent(m_hDC,m_hRC);
}

void WGLWindow::SwapBuffers()
{
	::SwapBuffers(m_hDC);
}

int WGLWindow::UpdatePalette()
{
	SelectPalette(m_hDC,(HPALETTE)m_GLPalette,FALSE);
	return RealizePalette(m_hDC);
}

void WGLWindow::UpdateColors()
{
	::UpdateColors(m_hDC);
}

void WGLWindow::setViewport(const RECT& rect)const
{
    glViewport(-50,-50,rect.right+50,rect.bottom+50);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrtho(-50.0,rect.right,-50.0,rect.bottom,-100.0,100.0);
}

//-------------------------------------------------------------------=72
// End of WGLWindow.cpp
//-------------------------------------------------------------------=72
