//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// WGLObject.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72
// OpenGL Object for Windows-OpenGL environment.
// WGLObject is used with WGLWindow.
//-------------------------------------------------------------------=72

#ifndef _WGL_OBJECT_H
#define _WGL_OBJECT_H

#include <afxwin.h>         // MFC core and standard components
#include <gl\gl.h>
#include <gl\glu.h>

#include "RRBoundingBox.h"

class WGLObject
{
  private:

	RRBoundingBox mBBox;

  protected:

	const RRBoundingBox& mfGetBBox()const{return mBBox;}
	void mfSetBBox(const RRBoundingBox& bbox){mBBox=bbox;}	

  public:

	WGLObject();
	WGLObject(const RRBoundingBox& bbox);
	WGLObject(const WGLObject& x);
	virtual ~WGLObject();

	const WGLObject& operator=(const WGLObject& x);

	const RRBoundingBox& getBBox()const{return mBBox;}
	void setBBox(const RRBoundingBox& bbox){mBBox=bbox;}

	virtual bool renderObject()const = 0;
};

#endif // _WGL_OBJECT_H

//-------------------------------------------------------------------=72
// End of WGLObject.h
//-------------------------------------------------------------------=72
