//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// WGLBitmap.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72
// WGLBitmap is a WGLObject which is specialized for 
// rendering bitmap data to OpenGL window.
//-------------------------------------------------------------------=72

#ifndef _WGL_BITMAP_H
#define _WGL_BITMAP_H

#include "WGLObject.h"

class WGLBitmap : public WGLObject
{
  private:

	int mDepth;
	unsigned char *mBitmap;
	GLenum mFormat;

  private: 

	void mfSetFormat();

  protected:

	int mfGetDepth()const{return mDepth;}

	void setBBox(
			const RRBoundingBox& bbox)
			{WGLObject::setBBox(bbox);}

  public:

	WGLBitmap();
	WGLBitmap(
			const RRBoundingBox& bbox,
			const int depth);
	WGLBitmap(
			const RRBoundingBox& bbox,
			const int depth,
			const unsigned char *bmp);
	WGLBitmap(const WGLBitmap& x);
	virtual ~WGLBitmap();
	
	const WGLBitmap& operator=(const WGLBitmap& x);

	virtual int getDepth()const{return mDepth;}
	// no setDepth(). use constructor.

	virtual const unsigned char *getBitmap()const
			{return mBitmap;}
	// no setBitmap(). use constructor.

	virtual bool renderObject()const;
};

#endif // _WGL_BITMAP_H

//-------------------------------------------------------------------=72
// End of WGLBitmap.h
//-------------------------------------------------------------------=72
