//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// WGLBitmap.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//  Feb/27/1999:	Added setDimension()
//					unsigned char * const getBitmap()
//
// Bugs:
//
//-------------------------------------------------------------------=72
// WGLBitmap is a WGLObject which is specialized for 
// rendering bitmap data to OpenGL window.
//-------------------------------------------------------------------=72

#ifndef _WGL_BITMAP_H
#define _WGL_BITMAP_H

#include "WGLObject.h"

class WGLBitmap : public WGLObject
{
  private:

	int mDepth;
	unsigned char *mBitmap;
	GLenum mFormat;

  private: 

	void mfSetFormat();

  protected:

	int mfGetDepth()const{return mDepth;}

	void setBBox(
			const RRBoundingBox& bbox)
			{WGLObject::setBBox(bbox);}

  public:

	WGLBitmap();
	WGLBitmap(
			const RRBoundingBox& bbox,
			const int depth);
	WGLBitmap(
			const RRBoundingBox& bbox,
			const int depth,
			const unsigned char *bmp);
	WGLBitmap(const WGLBitmap& x);
	virtual ~WGLBitmap();
	
	const WGLBitmap& operator=(const WGLBitmap& x);

	virtual int getDepth()const{return mDepth;}
	// no setDepth().

	virtual const unsigned char * const getBitmap()const
			{return mBitmap;}
	virtual unsigned char * const getBitmap()
			{return mBitmap;}
	// no setBitmap(). 

	virtual bool setDimension(
			const RRBoundingBox& bbox,
			const int depth);

	virtual bool renderObject()const;
};

#endif // _WGL_BITMAP_H

//-------------------------------------------------------------------=72
// End of WGLBitmap.h
//-------------------------------------------------------------------=72
