//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// WGLBitmap.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//  Feb/27/1999:	Added setDimension()
//					unsigned char * const getBitmap()
//
// Bugs:
//
//-------------------------------------------------------------------=72

#define _WGL_BITMAP_C

//#include "stdafx.h"

#include "WGLBitmap.h"

WGLBitmap::WGLBitmap()
:WGLObject(),
 mDepth(0),
 mBitmap(NULL),
 mFormat(GL_LUMINANCE)
{}

WGLBitmap::WGLBitmap(
			const RRBoundingBox& bbox,
			const int depth)
:WGLObject(bbox),
 mDepth(depth)
{
	int xs,ys;
	mfGetBBox().getSize(xs,ys);
	mBitmap = new unsigned char[xs*ys*mDepth];
	
	mfSetFormat();
}

WGLBitmap::WGLBitmap(
			const RRBoundingBox& bbox,
			const int depth,
			const unsigned char *bmp)
:WGLObject(bbox),
 mDepth(depth)
{
	int xs,ys;
	mfGetBBox().getSize(xs,ys);
	int bytes=xs*ys*mDepth;

	mBitmap = new unsigned char[bytes];
	memcpy(mBitmap,bmp,bytes);	
	mfSetFormat();
}

WGLBitmap::WGLBitmap(const WGLBitmap& x)
:WGLObject(x.mfGetBBox()),
 mDepth(x.mDepth)
{
	int xs,ys;
	mfGetBBox().getSize(xs,ys);
	int bytes=xs*ys*mDepth;

	mBitmap = new unsigned char[bytes];
	memcpy(mBitmap,x.mBitmap,bytes);	
	mfSetFormat();
}

WGLBitmap::~WGLBitmap()
{
	delete[] mBitmap;
	mBitmap=NULL;
}

const WGLBitmap& WGLBitmap::operator=(
			const WGLBitmap& x)
{
	mfSetBBox(x.mfGetBBox());
	mDepth=x.mDepth;

	int xs,ys;
	mfGetBBox().getSize(xs,ys);
	int bytes=xs*ys*mDepth;

	delete[] mBitmap;
	mBitmap = new unsigned char[bytes];
	memcpy(mBitmap,x.mBitmap,bytes);
	mfSetFormat();
	return *this; 
}

bool WGLBitmap::renderObject()const
{
	glPushMatrix();
	{
		glPixelStorei(GL_UNPACK_ALIGNMENT,1);
		glRasterPos2i(mfGetBBox().getBL().getX(),
		              mfGetBBox().getBL().getY());
		int xs,ys;
		mfGetBBox().getSize(xs,ys);

		if(xs==0 || ys==0 || mDepth==0)
			return false;

		glDrawPixels(xs,ys,mFormat,GL_UNSIGNED_BYTE,mBitmap);
	}
	glPopMatrix();

	return true;
}

void WGLBitmap::mfSetFormat()
{
	switch(mDepth)
	{
	  case 1:
		mFormat=GL_LUMINANCE;
		break;
	  case 3:
		mFormat=GL_RGB;
		break;
	  case 4:
		mFormat=GL_RGBA;
		break;
	  default:
	    mFormat=GL_LUMINANCE;
	}
}

bool WGLBitmap::setDimension(
			const RRBoundingBox& bbox,
			const int depth)
{
	WGLObject::setBBox(bbox);
	mDepth=depth;

	int xs,ys;
	mfGetBBox().getSize(xs,ys);
	mBitmap = new unsigned char[xs*ys*mDepth];
	
	mfSetFormat();

	return true;
}

//-------------------------------------------------------------------=72
// End of WGLBitmap.cpp
//-------------------------------------------------------------------=72
