//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRVec2.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
// Date:                 Nov/21/1998
// Version:              1.0
//
// Modification History:
//  Oct/31/1998:	Copied from eldVec2.h
//
// Bugs:
//
// Classes:
//
// Notes:
//
//-------------------------------------------------------------------=72
//
// RRVec2.h defines RRVec2 class.
// RRVec2 class is a 2-dimensional vector.
//
//-------------------------------------------------------------------=72

#ifndef _RR_VEC_2_H
#define _RR_VEC_2_H

#include "RRDef.h"

#include <math.h>

class RRGrid2;

class RRVec2
{
  private:

	double mX;
	double mY;

  public:
  
	RRVec2():mX(0),mY(0){}
	RRVec2(const double x,const double y):mX(x),mY(y){}
	RRVec2(const RRVec2& v):mX(v.mX),mY(v.mY){}
	RRVec2(const RRGrid2& v);
	virtual ~RRVec2(){mX=HUGE_VAL;mY=HUGE_VAL;}

	double getX()const{return mX;}
	void setX(double x){mX=x;}
	double getY()const{return mY;}
	void setY(double y){mY=y;}

	const RRVec2& operator=(const RRVec2& v);
	friend int operator==(const RRVec2& v1,const RRVec2& v2);
	friend int operator!=(const RRVec2& v1,const RRVec2& v2);
	friend RRVec2 operator+(const RRVec2& v1,const RRVec2& v2);
	friend RRVec2 operator-(const RRVec2& v1,const RRVec2& v2);
	friend RRVec2 operator*(const RRVec2& v,const double& r);
	friend RRVec2 operator*(const double& r,const RRVec2& v);
	friend double innerP(const RRVec2& v1,const RRVec2& v2);
	friend RRVec2 outerP(const RRVec2& v1,const RRVec2& v2);
};
    
#endif // _RR_VEC_2_H

//-------------------------------------------------------------------=72
// End of RRVec2.h
//-------------------------------------------------------------------=72
