//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRVec2.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
// Date:                 Nov/21/1998
// Version:              1.0
//
// Modification History:
//  Oct/31/1998:	Copied from eldVec2.cpp
//
// Bugs:
//
// Classes:
//
// Notes:
//
//-------------------------------------------------------------------=72

#include "RRVec2.h"
#include "RRGrid2.h"
	
RRVec2::RRVec2(const RRGrid2& v)
:mX(v.getX()),
 mY(v.getY())
{}
	
const RRVec2& RRVec2::operator=(const RRVec2& v)
{
	mX=v.mX; mY=v.mY;
	return *this;
}

int operator==(const RRVec2& v1,const RRVec2& v2)
{
	return (v1.mX==v2.mX && v1.mY==v2.mY)?1:0;
}

int operator!=(const RRVec2& v1,const RRVec2& v2)
{
	return (v1.mX!=v2.mX || v1.mY!=v2.mY)?1:0;
}

RRVec2 operator+(const RRVec2& v1,const RRVec2& v2)
{
	return RRVec2(v1.mX+v2.mX,v1.mY+v2.mY);
}

RRVec2 operator-(const RRVec2& v1,const RRVec2& v2)
{
	return RRVec2(v1.mX-v2.mX,v1.mY-v2.mY);
}

RRVec2 operator*(const RRVec2& v,const double& r)
{
	return RRVec2(v.mX*r,v.mY*r);
}

RRVec2 operator*(const double& r,const RRVec2& v)
{
	return RRVec2(v.mX*r,v.mY*r);
}


double innerP(const RRVec2& v1,const RRVec2& v2)
{
	return v1.mX*v2.mX+v1.mY*v2.mY;
}

RRVec2 outerP(const RRVec2& v1,const RRVec2& v2)
{// not implemented
	return RRVec2();
}
    
//-------------------------------------------------------------------=72
// End of RRVec2.cpp
//-------------------------------------------------------------------=72
