//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRPolynomial.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Oct/31/1998:	Copied from eldPolynomial.h
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
// RRPolynomial class is a 1-dimenstional polynomial function.
//
// y = f(x) = c0 + c1*x + c2*xx + c3*xxx + ...
//
//-------------------------------------------------------------------=72

#ifndef _RR_POLYNOMIAL_H
#define _RR_POLYNOMIAL_H

#include "RRDef.h"
#include "RRArray.h"

extern const double RRPLY_D_PRECISION; // default computing precision
									   // for getX() and getDerivative().	

class RRPolynomial
{
  private:

	RRArray< double > mCoeff;

  private:

	double mfGetY(
			const double x)const;
	RRArray< double > mfGetX(
			const double y,
			const double precision = RRPLY_D_PRECISION)const;
	RRPolynomial mfGetDerivative(
			const int order,
			const double precision = RRPLY_D_PRECISION)const;
	double mfFindIntersection(
			const double x0,
			const double x1,
			const double y,
			const double precision = RRPLY_D_PRECISION)const;

  public:

	RRPolynomial();
	RRPolynomial(const RRArray< double >& coeff);
	// create polynomial with given coefficients.
	RRPolynomial(const RRPolynomial& x);
	~RRPolynomial();

	const RRPolynomial& operator=(const RRPolynomial& x);

	int getOrder()const;
	const RRArray< double >& getCoeff()const;

	double getY(
			const double x)const;
	// return y = f(x)

	RRArray< double > getX(
			const double y,
			const double precision = RRPLY_D_PRECISION)const;
	// return x = f_inverse(y).
	// x = f_inverce(y) may have multiple solution. return values are
	// aligned with increasing order.

	RRPolynomial getDerivative(
			const int order,
			const double precision = RRPLY_D_PRECISION)const;
	// return (order)-th derivative of the polynomial.

	friend bool operator==(const RRPolynomial& p1,const RRPolynomial& p2);
	friend bool operator!=(const RRPolynomial& p1,const RRPolynomial& p2);
};

#endif // _RR_POLYNOMIAL_H

//-------------------------------------------------------------------=72
// End of RRPolynomial.h
//-------------------------------------------------------------------=72

