//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRNumberedFileName.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Oct/27/1998:	Copied from eldNumberedFileName.h
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
//	RRNumberedFileName is a set of numbered file names.
//
//	A numbered file name appears with the following style ...
//		<preposition><number with fixed digits><postposition>
//	For example, if <preposition> = "tomoo.", <postposition> = ".tom",
//	filenames are "tomoo.0.tom", "tomoo.1.tom","tomoo.2.tom",...
// 
//	The number of digits is automatically adjusted to the maximum
//  number. If the maximum number is set to 100, file names will be 
//	"tomoo.000.tom", "tomoo.001.tom",...,"tomoo.100.tom" (101 files).
//	Note that numbering always starts from 0. 
//
//-------------------------------------------------------------------=72

#ifndef _RR_NUMBERED_FILE_NAME_H
#define _RR_NUMBERED_FILE_NAME_H

#include "RRDef.h"
#include "RRFileName.h"

#include <string.h>

class RRNumberedFileName
{
  private:
	
	RRFileName mPrePosition;
	RRFileName mPostPosition;
	int mMaxNumber;
	int mNumDigits;

  private:
	
	int mfCalcNumDigits(const int n)const;
	void mfMakeNumPart(
			const int i,
			char *num)const;
	void mfMakeFileName(
			const int i,
			char *ret)const;

  public:

	RRNumberedFileName();
	RRNumberedFileName(
			const int maxnum,			
			const char *prep = "",
			const char *postp = "");
	// spesifies maximum number, preposition and postposition.

	RRNumberedFileName(const RRNumberedFileName& x);

	const RRNumberedFileName& operator=(
			const RRNumberedFileName& x);

	const char *getPrePosition()const;
	void setPrePosition(const char *prep);
	const char *getPostPosition()const;
	void setPostPosition(const char *postp);
	int getMaxNumber()const;
	void setMaxNumber(const int maxnum);
	// if maxnum<0, 0 is set to mMaxNumber.

	RRFileName getFileName(const int i)const;
	// return i-th filename. 0<=i<=mMaxNumber.
	// if i is out of range, return "".
};

#endif // _RR_NUMBERED_FILE_NAME_H

//-------------------------------------------------------------------=72
// End of RRNumberedFileName.h
//-------------------------------------------------------------------=72
