//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRNumberedFileName.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Oct/27/1998:	Copied from eldNumberedFileName.cpp
//
// Bugs:
//
//-------------------------------------------------------------------=72

#include "RRNumberedFileName.h"

#include <stdio.h>
#include <math.h>

int RRNumberedFileName::mfCalcNumDigits(const int n)const
{
	if(n<=0)
		return 1;
	else
		return int(log10(n)+1);
}

RRNumberedFileName::RRNumberedFileName()
:mPrePosition(),
 mPostPosition(),
 mMaxNumber(0)
{
	mNumDigits=mfCalcNumDigits(mMaxNumber);
}

RRNumberedFileName::RRNumberedFileName(
			const int maxnum,
			const char *prep,
			const char *postp)
:mPrePosition(prep),
 mPostPosition(postp),
 mMaxNumber(maxnum)
{
	mNumDigits=mfCalcNumDigits(mMaxNumber);
}

RRNumberedFileName::RRNumberedFileName(
			const RRNumberedFileName& x)
:mPrePosition(x.mPrePosition),
 mPostPosition(x.mPostPosition),
 mMaxNumber(x.mMaxNumber)
{
	mNumDigits=mfCalcNumDigits(mMaxNumber);
}

const RRNumberedFileName& RRNumberedFileName::operator=(
			const RRNumberedFileName& x)
{
	mPrePosition=x.mPrePosition;
	mPostPosition=x.mPostPosition;
	mMaxNumber=x.mMaxNumber;
	mNumDigits=mfCalcNumDigits(mMaxNumber);
	return *this;
}

const char *RRNumberedFileName::getPrePosition()const
{
	return mPrePosition(0);
}

void RRNumberedFileName::setPrePosition(const char *prep)
{
	mPrePosition=RRFileName(prep);
}

const char *RRNumberedFileName::getPostPosition()const
{
	return mPostPosition(0);
}

void RRNumberedFileName::setPostPosition(const char *postp)
{
	mPostPosition=RRFileName(postp);
}

int RRNumberedFileName::getMaxNumber()const
{
	return mMaxNumber;
}

void RRNumberedFileName::setMaxNumber(const int maxnum)
{
	mMaxNumber=(maxnum<0)?0:maxnum;
	mNumDigits=mfCalcNumDigits(mMaxNumber);
}

void RRNumberedFileName::mfMakeNumPart(
			const int i,
			char *num)const
{
	char n[256];
	sprintf(n,"%.255d",i);
	strcpy(num,&(n[256-mNumDigits-1]));
}

void RRNumberedFileName::mfMakeFileName(
			const int i,
			char *ret)const
{
	char num[256];
	mfMakeNumPart(i,num);
	sprintf(ret,"%s%s%s",mPrePosition(0),num,mPostPosition(0));
}

RRFileName RRNumberedFileName::getFileName(const int i)const
{
	if(i<0 || i>mMaxNumber)
		return "";

	char ret[256];
	mfMakeFileName(i,ret);
	return RRFileName(ret);
}

//-------------------------------------------------------------------=72
// End of RRNumberedFileName.cpp
//-------------------------------------------------------------------=72
