//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRGrid2.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Oct/27/1998:	Copied from eldGrid2.h
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
// RRGrid2 class is a 2-dimensional grid.
// RRGrid2 has a 2-D integer coordinate.
//
//-------------------------------------------------------------------=72

#ifndef _RR_GRID_2_H
#define _RR_GRID_2_H

#include "RRDef.h"

class RRGrid2
{
  private:

	int mX;
	int mY;

  public:
  
	RRGrid2();
	RRGrid2(const int x,const int y);
	RRGrid2(const RRGrid2& v);
	virtual ~RRGrid2();

	int getX()const;
	void setX(int x);
	int getY()const;
	void setY(int y);

	const RRGrid2& operator=(const RRGrid2& v);
	friend bool operator==(const RRGrid2& v1,const RRGrid2& v2);
	friend bool operator!=(const RRGrid2& v1,const RRGrid2& v2);
	friend RRGrid2 operator+(const RRGrid2& v1,const RRGrid2& v2);
	friend RRGrid2 operator-(const RRGrid2& v1,const RRGrid2& v2);
	friend RRGrid2 operator*(const RRGrid2& v,const int& r);
	friend RRGrid2 operator*(const int& r,const RRGrid2& v);
};
    
#endif // _RR_GRID_2_H

//-------------------------------------------------------------------=72
// End of RRGrid2.h
//-------------------------------------------------------------------=72
