//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRGrid2.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Oct/27/1998:	Copied from eldGrid2.cpp
//
// Bugs:
//
//-------------------------------------------------------------------=72

#include "RRGrid2.h"

#include <math.h>
#include <limits.h>

RRGrid2::RRGrid2()
:mX(0),
 mY(0)
{}

RRGrid2::RRGrid2(const int x,const int y)
:mX(x),
 mY(y)
{}

RRGrid2::RRGrid2(const RRGrid2& v)
:mX(v.mX),
 mY(v.mY)
{}

RRGrid2::~RRGrid2()
{
	mX=INT_MAX;
	mY=INT_MAX;
}

int RRGrid2::getX()const
{
	return mX;
}

void RRGrid2::setX(int x)
{
	mX=x;
}

int RRGrid2::getY()const
{
	return mY;
}

void RRGrid2::setY(int y)
{
	mY=y;
}

const RRGrid2& RRGrid2::operator=(const RRGrid2& v)
{
	mX=v.mX;
	mY=v.mY;
	return *this;
}

bool operator==(const RRGrid2& v1,const RRGrid2& v2)
{
	return (v1.mX==v2.mX && v1.mY==v2.mY)?true:false;
}

bool operator!=(const RRGrid2& v1,const RRGrid2& v2)
{
	if(v1.mX!=v2.mX || v1.mY!=v2.mY)
		return true;
	else
		return false;
}

RRGrid2 operator+(const RRGrid2& v1,const RRGrid2& v2)
{
	return RRGrid2(v1.mX+v2.mX,v1.mY+v2.mY);
}

RRGrid2 operator-(const RRGrid2& v1,const RRGrid2& v2)
{
	return RRGrid2(v1.mX-v2.mX,v1.mY-v2.mY);
}

RRGrid2 operator*(const RRGrid2& v,const int& r)
{
	return RRGrid2(v.mX*r,v.mY*r);
}

RRGrid2 operator*(const int& r,const RRGrid2& v)
{
	return operator*(v,r);
}

//-------------------------------------------------------------------=72
// End of RRGrid2.cpp
//-------------------------------------------------------------------=72
