//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRFileName.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
// Date:                 Oct/27/1998
// Version:              1.0
//
// Modification History:
//  Oct/27/1998:	Copied from eldFileName.h	
//
// Bugs:
//
// Classes:
//
// Notes:
//	This file defines main() of rrselect.
//
//-------------------------------------------------------------------=72

#ifndef _RR_FILE_NAME_H
#define _RR_FILE_NAME_H

#include "RRDef.h"

#include <string.h>

class RRFileName
{
  private:

	char mFN[256];

  public:

	RRFileName(){}
	RRFileName(const RRFileName& x){strcpy(mFN,x.mFN);}
	RRFileName(const char *s){strcpy(mFN,s);}

	const RRFileName& operator=(const RRFileName& x)
	{strcpy(mFN,x.mFN); return *this;}
	const RRFileName& operator=(const char *s){strcpy(mFN,s); return *this;}

	const char *operator()(int i)const{return &(mFN[i]);}
	char *operator()(int i){return &(mFN[i]);}

	const char *operator&()const{return mFN;}
	char *operator&(){return mFN;}

	const char operator[](int i)const{return mFN[i];}

	friend int operator==(const RRFileName& x0,const RRFileName& x1)
	{return (strcmp(x0.mFN,x1.mFN)==0)?1:0;}

	RRFileName getRoot()const;		// aaa/bbb of aaa/bbb.ccc
	RRFileName getExtension()const; // .ccc of aaa/bbb.ccc
	RRFileName getHead()const;		// aaa/ of aaa/bbb.ccc
	RRFileName getTail()const;		// bbb.ccc of aaa/bbb.ccc 

	//const char *getExtension()const{return strrchr(mFN,'.');}
	RRFileName getExtension()const{return RRFileName(strrchr(mFN,'.'));}
	RRFileName getBody()const
	{
		char ret[256];
		memset(ret,0,256);
		strncpy(ret,strrchr(mFN,'/')+1,strlen(mFN)-strlen(strrchr(mFN,'.')));
		return RRFileName(ret);
	}
	RRFileName getDirectory()const
	{
		char ret[256];
		memset(ret,0,256);
		strncpy(ret,mFN,strlen(mFN)-strlen(strrchr(mFN,'/')+1));
		return RRFileName(ret);
	}
};

#endif // _RR_FILE_NAME_H

//-------------------------------------------------------------------=72
// End of RRFileName.h
//-------------------------------------------------------------------=72
