//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRField.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Oct/27/1998:	Copied from eldField.h
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
// This file defines RRField class.
// The RRField class is a 2-dimensional array of data.
//
//-------------------------------------------------------------------=72

#ifndef _RR_FIELD_H
#define _RR_FIELD_H

#include "RRDef.h"
#include "RRArray.h"

template <class T>
class RRField
{
  private:

	RRArray< RRArray< T > > mElem;

  public:
  
	RRField();
	RRField(const int xs,const int ys);
	// create a (xs)x(ys) field.
	RRField(const int xs,const int ys,const T& elem);
	// initialize all elements with (elem).
	RRField(const RRField<T>& v);
	virtual ~RRField();

	void getSize(int& x, int& y)const;
	void setSize(const int x,const int y);

	const T& getElem(const int x,const int y)const;
	void setElem(const int x,const int y,const T& elem);

	const RRField<T>& operator=(const RRField<T>& v);
	friend bool operator==(const RRField<T>& v1,const RRField<T>& v2);
	friend bool operator!=(const RRField<T>& v1,const RRField<T>& v2);
};
    

template <class T>
RRField<T>::RRField()
:mElem()
{}

template <class T>
RRField<T>::RRField(const int xs,const int ys)
:mElem(ys)
{
	for(int i=0;i<ys;i++)
		mElem[i].setSize(xs);
}

template <class T>
RRField<T>::RRField(const int xs,const int ys,const T& elem)
:mElem(ys)
{
	for(int i=0;i<ys;i++)
	{
		mElem[i].setSize(xs);
		for(int j=0;j<xs;j++)
			mElem[i][j]=elem;
	}
}

template <class T>
RRField<T>::RRField(const RRField<T>& v)
:mElem(v.mElem)
{}

template <class T>
RRField<T>::~RRField()
{}

template <class T>
void RRField<T>::getSize(int& x, int& y)const
{
	y=mElem.getSize();
	x=(y==0)?0:mElem[0].getSize();
}

template <class T>
void RRField<T>::setSize(const int x,const int y)
{
	assert(x>=0);
	assert(y>=0);

	mElem.setSize(y);
	for(int i=0;i<y;i++)
		mElem[i].setSize(x);
}

template <class T>
const T& RRField<T>::getElem(const int x,const int y)const
{
	return mElem[y][x];
}

template <class T>
void RRField<T>::setElem(const int x,const int y,const T& elem)
{
	mElem[y][x]=elem;
}

template <class T>
const RRField<T>& RRField<T>::operator=(const RRField<T>& v)
{
	mElem=v.mElem;
	return *this;
}

template <class T>
bool operator==(const RRField<T>& v1,const RRField<T>& v2)
{
	return (v1.mElem==v2.mElem)?true:false;
}

template <class T>
bool operator!=(const RRField<T>& v1,const RRField<T>& v2)
{
	return (v1.mElem!=v2.mElem)?true:false;
}

#endif // _RR_FIELD_H

//-------------------------------------------------------------------=72
// End of RRField.h
//-------------------------------------------------------------------=72
