//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRDef.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Oct/27/1998:	Copied from RRDef.h
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
// This file types, consts and macros which are commonly used in RASCAL.
//
//-------------------------------------------------------------------=72

#ifndef _RR_DEF_H
#define _RR_DEF_H

#include <stdlib.h>

#define M_E             2.7182818284590452354

#define M_LOG2E         1.4426950408889634074

#define M_LOG10E        0.43429448190325182765

#define M_LN2           0.69314718055994530942

#define M_LN10          2.30258509299404568402

#define M_PI            3.14159265358979323846

#define M_PI_2          1.57079632679489661923

#define M_PI_4          0.78539816339744830962

#define M_1_PI          0.31830988618379067154

#define M_2_PI          0.63661977236758134308

#define M_2_SQRTPI      1.12837916709551257390

#define M_SQRT2         1.41421356237309504880

#define M_SQRT1_2       0.70710678118654752440

//#ifndef HUGE_VAL
//#define HUGE_VAL       (1.0e12)
//#endif // HUGE_VAL

typedef const char* RRDataIndividualName;
typedef const char* RRDataTypeName;
typedef const char* RRProcessTypeName;

extern RRDataIndividualName RRDIN_D_DATA_INDIVIDUAL_NAME;
extern RRDataTypeName RRDTN_D_DATA_TYPE_NAME;
extern RRProcessTypeName RRPTN_D_PROCESS_TYPE_NAME;

typedef enum
{
    RR_ERROR = -1,
    RR_SUCCESS = 0,
    RR_LOCKED = 1,
    RR_UNLOCKED = 2
} RRStatus;

#endif // _RR_DEF_H

//-------------------------------------------------------------------=72
// End of RRDef.h
//-------------------------------------------------------------------=72
