//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRBSpline.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Apr/02/1999:	Copied from eldBSpline.h
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
// RRBSpline.h defines RRBSpline class.
//
// s(x) = SUMi[ c[i]*N[i,k+1](x) ] , a<=x<=b, -k<=i<=g
// s(a) = c[-k], s(b) = c[g+1] : coincident boundary property
// N[i,k+1](x) : base of B-spline
// 
//-------------------------------------------------------------------=72

#ifndef _RR_B_SPLINE_H
#define _RR_B_SPLINE_H

#include "RRDef.h"
#include "RRArray.h"
#include "RRVec2.h"

class RRBSpline
{
  private:

	int mDegree;
	RRArray< double > mKnot;
	RRArray< double > mCoeff;

  private:

	RRStatus mfMakeMatrix(
			const RRArray< RRVec2 >& p,
			const int dim,
			double *a,
			double *b)const;
	double mfGetKnot(int i)const;
	double mfGetCoeff(int i)const;
	int mfGetPolynomialIndex(double x)const;
	double mfGetBase(int i,int d,double x)const;
	RRStatus mfGaussJordan(
			const int dim,
			double *a,  // a[dim][dim]
			double *b,  // b[dim]
			double *x); // x[dim]
	RRStatus mfScaleP(
			const RRArray< RRVec2 >& p,
			RRArray< RRVec2 >& sp,
			double& factor);

  public:

	RRBSpline(const int degree);
	RRBSpline(const int degree,const RRArray< double >& knot);
	RRBSpline(
			const int degree,
			const RRArray< double >& knot,
			const RRArray< double >& coeff);
	RRBSpline(const RRBSpline& x);
	~RRBSpline();

	const RRBSpline& operator=(const RRBSpline& x);

	int getDegree()const{return mDegree;}
	const RRArray< double >& getKnot()const{return mKnot;}
	RRStatus setKnot(const RRArray< double >& knot);
	const RRArray< double >& getCoeff()const{return mCoeff;}
	RRStatus setCoeff(const RRArray< double >& coeff);

	RRStatus calcCoeff(const RRArray< RRVec2 >& p);
	// compute with least square

	double getY(double x)const;
	double getBase(int i,int d,double x)const{return mfGetBase(i,d,x);}
	RRBSpline getDerivative()const;

	friend bool operator==(const RRBSpline& p1,const RRBSpline& p2);
	friend bool operator!=(const RRBSpline& p1,const RRBSpline& p2);
};

#endif // _RR_B_SPLINE_H

//-------------------------------------------------------------------=72
// End of RRBSpline.h
//-------------------------------------------------------------------=72

