//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRSelectParamData.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.1
//
// Modification History:
//  Oct/27/1998:	Copied from eldSelectParamData.h	
//  Apr/02/1999:	Auto-trimming option was added.	
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
//	RRSelectParamData class is a RRDataSubstance class.
//	RRSelectParamData stores computing parameter of RRSelectProc.
//
//	int kernelSize
//		Size of spatial averaging filter. default value is 3 (=3x3).
//		Increasing kernel size -> Data selecting becomes severe. But 
//		number of selected data decreases.
//
//	double trimRatio
//		Ratio of triming size to the original image size. This trimming
//		is useful to reject side area which may have some distortion 
//		such as vegnetting. If trimming ratio is 0.7, the size of trimmed 
//		rectangle is 70% of the original one. But the aspect ratio does 
//		not change. default value 1. that means no trimming. 
//		Decreasing triming ratio -> pixels in center area are mainly 
//		selected. So, data becomes more safe (less ditortion), but the 
//		number of data decreases.
//		If trimming ratio is set to 0.0, this means that auto-trimming 
//		mode is selected. In auto-trimming mode, trimming size is 
//		automatically adjusted by checking amount of vegnetting effect
//		in the input images. Another difference from manual mode is 
//		that the trimming shape is circle. In the current version, you 
//		cannot use both manual rectanglar trimming and automatic circular
//		trimming simultaneously.
//
//	double saturationLevel
//		Upper clipping level of pixel value. This must be under 1 if you 
//		want to reject saturated pixels. default value is 0.990.
//		Decreasing saturation level -> Some camera outputs are clipped
//		at a level under 0.990. You must decrease this parameter if you
//		find such clipping. However, too low setting of saturation level
//		might bring lack of data around 1.
//
//	double noiseLevel
//		Lower clipping level of pixel value. This must be over 0 if you 
//		want to reject black-out and noisy pixels. default value is 
//		0.010.
//		Increasing noise level -> Data selecting becomes soft. So, the 
//		number of selected data increase. But selected data becomes
//		noisy.
//
//	int maxSamplingNumber
//		Upper limit of number of samples from 1 image pair. This 
//		parameter is for the sake of computational cost. default value
//		is 1000.
//
//	To tune rrselect program, you can modify a parameter setting file
//	which will be specified as the 3rd arg of rrselect. 
//	Parameter setting file must be described as the followings.
//	 
//	id	<filename>	RRSelectParamData
//	creator	nobody
//	numSource	0
//	kernelSize	3
//	trimRatio	7.000000e-001
//	saturationLevel	9.900000e-001
//	noiseLevel	0.100000e-001
//	maxSamplingNumber	1000
//
//-------------------------------------------------------------------=72

#ifndef _RR_SELECT_PARAM_DATA_H
#define _RR_SELECT_PARAM_DATA_H

#include "RRDef.h"
#include "RRDataSubstance.h"
#include "RRArray.h"
#include "RRFileName.h"

extern const int RRSPD_D_KERNEL_SIZE;
extern const double RRSPD_D_TRIM_RATIO;
extern const double RRSPD_D_SATURATION_LEVEL;
extern const double RRSPD_D_NOISE_LEVEL;
extern const int RRSPD_D_MAX_SAMPLING_NUMBER;

class RRSelectParamData : public RRDataSubstance
{
  private:

	int mKernelSize;
	double mTrimRatio;
	double mSaturationLevel;
	double mNoiseLevel;
	int mMaxSamplingNumber;

  public:

    RRSelectParamData();
	// create with default values.
 
    RRSelectParamData(
			const int kernelSize,
			const double trimRatio,
			const double saturationLevel,
			const double noiseLevel,
			const int maxSamplingNumber);

	static const char *getType(){return "RRSelectParamData";}

	int getKernelSize()const{return mKernelSize;}
	void setKernelSize(const int k){mKernelSize=k;}

	double getTrimRatio()const{return mTrimRatio;}
	void setTrimRatio(const double t){mTrimRatio=t;}

	double getSaturationLevel()const{return mSaturationLevel;}
	void setSaturationLevel(const double s){mSaturationLevel=s;}

	double getNoiseLevel()const{return mNoiseLevel;}
	void setNoiseLevel(const double n){mNoiseLevel=n;}

	int getMaxSamplingNumber()const{return mMaxSamplingNumber;}
	void setMaxSamplingNumber(const int m){mMaxSamplingNumber=m;}

    virtual RRStatus save(FILE *fp)const;
    virtual RRStatus load(FILE *fp);

    virtual const RRDataSubstance& operator=(const RRDataSubstance& s);
    const RRSelectParamData& operator=(const RRSelectParamData& s);

	bool operator==(const RRSelectParamData& x)const;
};

#endif // _RR_SELECT_PARAM_DATA_H

//-------------------------------------------------------------------=72
// End of RRSelectParamData.h
//-------------------------------------------------------------------=72
