//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRSelectParamData.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
// Date:                 Oct/27/1998
// Version:              1.0
//
// Modification History:
//  Oct/27/1998:	Copied from eldSelectParamData.cpp
//
// Bugs:
//
// Classes:
//
// Notes:
//
//-------------------------------------------------------------------=72

#include "RRSelectParamData.h"

#include <string.h>
#include <math.h>

const int RRSPD_D_KERNEL_SIZE = 3;
const double RRSPD_D_TRIM_RATIO = 1.;
const double RRSPD_D_SATURATION_LEVEL = 0.990;
const double RRSPD_D_NOISE_LEVEL = 0.010;
const int RRSPD_D_MAX_SAMPLING_NUMBER = 1000;

RRSelectParamData::RRSelectParamData()
:mKernelSize(RRSPD_D_KERNEL_SIZE),
 mTrimRatio(RRSPD_D_TRIM_RATIO),
 mSaturationLevel(RRSPD_D_SATURATION_LEVEL),
 mNoiseLevel(RRSPD_D_NOISE_LEVEL),
 mMaxSamplingNumber(RRSPD_D_MAX_SAMPLING_NUMBER)
{}

RRSelectParamData::RRSelectParamData(
			const int kernelSize,
			const double trimRatio,
			const double saturationLevel,
			const double noiseLevel,
			const int maxSamplingNumber)
:mKernelSize(kernelSize),
 mTrimRatio(trimRatio),
 mSaturationLevel(saturationLevel),
 mNoiseLevel(noiseLevel),
 mMaxSamplingNumber(maxSamplingNumber)
{}
 	
RRStatus RRSelectParamData::save(FILE *fp)const
{
	fprintf(fp,"kernelSize\t%d\n",mKernelSize);
	fprintf(fp,"trimRatio\t%le\n",mTrimRatio);
	fprintf(fp,"saturationLevel\t%le\n",mSaturationLevel);
	fprintf(fp,"noiseLevel\t%le\n",mNoiseLevel);
	fprintf(fp,"maxSamplingNumber\t%d\n",mMaxSamplingNumber);
	fflush(fp);
	return RR_SUCCESS;
}

RRStatus RRSelectParamData::load(FILE *fp)
{
	fscanf(fp,"kernelSize\t%d\n",&mKernelSize);
	fscanf(fp,"trimRatio\t%le\n",&mTrimRatio);
	fscanf(fp,"saturationLevel\t%le\n",&mSaturationLevel);
	fscanf(fp,"noiseLevel\t%le\n",&mNoiseLevel);
	fscanf(fp,"maxSamplingNumber\t%d\n",&mMaxSamplingNumber);
	fflush(fp);
	return RR_SUCCESS;
}

const RRDataSubstance& RRSelectParamData::operator=(const RRDataSubstance& s)
{
	const RRSelectParamData& ss=(const RRSelectParamData&)s;
    return (const RRDataSubstance&)operator=(ss);
}

const RRSelectParamData& RRSelectParamData::operator=(
			const RRSelectParamData& s)
{
	mKernelSize=s.mKernelSize;
	mTrimRatio=s.mTrimRatio;
	mSaturationLevel=s.mSaturationLevel;
	mNoiseLevel=s.mNoiseLevel;
	mMaxSamplingNumber=s.mMaxSamplingNumber;
    return *this;
}

bool RRSelectParamData::operator==(const RRSelectParamData& x)const
{
	return (mKernelSize==x.mKernelSize &&
	        mTrimRatio==x.mTrimRatio &&
	        mSaturationLevel==x.mSaturationLevel &&
	        mNoiseLevel==x.mNoiseLevel &&
	        mMaxSamplingNumber==x.mMaxSamplingNumber)?true:false;
}

//-------------------------------------------------------------------=72
// End of RRSelectParamData.cpp
//-------------------------------------------------------------------=72
