//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRPixelStatisticsData.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Oct/27/1998:	Copied from eldPixelStatisticsData.h
//  Dec/02/1998:	Added member mNumSamples
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
//	RRPixelStatisticsData class is a RRDataSubstance class.
//	RRPixelStatisticsData stores the result of averaging. 
//	Both mean and variance values of every pixel are stored as double
//	precision.
//
//-------------------------------------------------------------------=72

#ifndef _RR_PIXEL_STATISTICS_DATA_H
#define _RR_PIXEL_STATISTICS_DATA_H

#include "RRDef.h"
#include "RRDataSubstance.h"
#include "RRField.h"

class RRPixelStatisticsData : public RRDataSubstance
{
  private:

	int mNumSamples;
	RRField< double > mMean;
	RRField< double > mVariance;

  private:

	RRStatus mfCheckDataRange(const int x,const int y)const;

  public:

	RRPixelStatisticsData();

	static const char *getType(){return "RRPixelStatisticsData";}

	RRStatus getSize(int& xs,int& ys)const;
	RRStatus setSize(const int xs,const int ys);

	int getNumSamples()const{return mNumSamples;}
	void setNumSamples(const int n){mNumSamples=n;}

	double getMeanAt(const int x,const int y)const;
	RRStatus setMeanAt(const int x,const int y,const double mean);
	// get/set mean value at (x,y).
	// when (x,y) is out of range of the data size, getMeanAt() returns
	// HUGE_VAL, setMeanAt() returns RR_ERROR.

	double getVarianceAt(const int x,const int y)const;
	RRStatus setVarianceAt(const int x,const int y,const double variance);
	// get/set variance value at (x,y).
	// when (x,y) is out of range of the data size, getVarianceAt() returns
	// HUGE_VAL, setVarianceAt() returns RR_ERROR.

 	const RRField< double >& getAllVariance()const{return mVariance;}
	const RRField< double >& getAllMean()const{return mMean;}
	RRStatus setAllMeanAndVariance(
			const RRField< double >& mean,
			const RRField< double >& variance);
	// when the size of mean and variance is defferent, returns RR_ERROR.

    virtual RRStatus save(FILE *fp)const;
    virtual RRStatus load(FILE *fp);

    RRStatus saveBinary(FILE *fp)const;
    RRStatus loadBinary(FILE *fp);
	// save/load binary data. smaller.
	
    virtual const RRDataSubstance& operator=(const RRDataSubstance& s);
    const RRPixelStatisticsData& operator=(const RRPixelStatisticsData& s);
	bool operator==(const RRPixelStatisticsData& x)const;
};

#endif // _RR_PIXEL_STATISTICS_DATA_H

//-------------------------------------------------------------------=72
// End of RRPixelStatisticsData.h
//-------------------------------------------------------------------=72
