//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRImageArrayData.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
// Date:                 Oct/27/1998
// Version:              1.0
//
// Modification History:
//  Oct/27/1998:	Copied from eldImageArrayData.h	
//
// Bugs:
//
// Classes:
//
// Notes:
//
//-------------------------------------------------------------------=72
//
// This file defines RRImageArrayData class.
// The RRImageArrayData class is a RRDataSubstance class which includes
// an array of image file names.
// 
//-------------------------------------------------------------------=72

#ifndef _RR_IMAGE_ARRAY_DATA_H
#define _RR_IMAGE_ARRAY_DATA_H

#include "RRDef.h"
#include "RRDataSubstance.h"
#include "RRArray.h"
#include "RRFileName.h"

class RRImageArrayData : public RRDataSubstance
{
  private:

	RRArray< RRFileName > mImageName;

  public:

    RRImageArrayData();
 
	static const char *getType(){return "RRImageArrayData";}

	int getNumImages()const{return mImageName.getSize();}
	void setNumImages(int n){mImageName.setSize(n);}

    const char *getImageName(int idx)const;
    RRStatus setImageName(int idx,const char *img);

    virtual RRStatus save(FILE *fp)const;
    virtual RRStatus load(FILE *fp);

    virtual const RRDataSubstance& operator=(const RRDataSubstance& s);
    const RRImageArrayData& operator=(const RRImageArrayData& s);

	int operator==(const RRImageArrayData& x)const;
};

#endif // _RR_IMAGE_ARRAY_DATA_H

//-------------------------------------------------------------------=72
// End of RRImageArrayData.h
//-------------------------------------------------------------------=72
