//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRImageArrayData.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
// Date:                 Oct/27/1998
// Version:              1.0
//
// Modification History:
//  Oct/27/1998:	Copied from eldImageArrayData.cpp
//
// Bugs:
//
// Classes:
//
// Notes:
//
//-------------------------------------------------------------------=72

#include "RRImageArrayData.h"

#include <string.h>
#include <math.h>

RRImageArrayData::RRImageArrayData()
:mImageName()
{}
 	
const char *RRImageArrayData::getImageName(int idx)const
{
	if(idx>=mImageName.getSize())
		return NULL;
	else
		return &(mImageName[idx]);
}

RRStatus RRImageArrayData::setImageName(int idx,const char *img)
{
	if(strlen(img)>=64)
		return RR_ERROR;

	if(idx<mImageName.getSize())
	{
		mImageName[idx]=img; 
		return RR_SUCCESS;
	}
	else
		return RR_ERROR;
}

RRStatus RRImageArrayData::save(FILE *fp)const
{
	fprintf(fp,"numImages\t%d\n",mImageName.getSize());
	for(int i=0;i<mImageName.getSize();i++)
		fprintf(fp,"imageName\t%d\t%s\n",i,&(mImageName[i]));
	fflush(fp);
	return RR_SUCCESS;
}

RRStatus RRImageArrayData::load(FILE *fp)
{
	int n;
	fscanf(fp,"numImages\t%d\n",&n);
	mImageName.setSize(n);
	for(int i=0;i<mImageName.getSize();i++)
		fscanf(fp,"imageName\t%d\t%s\n",&n,&(mImageName[i]));
	fflush(fp);
	return RR_SUCCESS;
}

const RRDataSubstance& RRImageArrayData::operator=(const RRDataSubstance& s)
{
	const RRImageArrayData& ss=(const RRImageArrayData&)s;
    return (const RRDataSubstance&)operator=(ss);
}

const RRImageArrayData& RRImageArrayData::operator=(const RRImageArrayData& s)
{
	mImageName=s.mImageName;
    return *this;
}

int RRImageArrayData::operator==(const RRImageArrayData& x)const
{
	return (mImageName==x.mImageName)?1:0;
}

//-------------------------------------------------------------------=72
// End of RRImageArrayData.cpp
//-------------------------------------------------------------------=72
