//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRIaCurveData.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Oct/31/1998:	Copied from eldIaCurveData.h
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
//	RRIaCurveData class is a RRDataSubstance class.
//	RRIaCurveData contains a polynomial as a radiometric response 
//	function curve and an array of doubles as exposure ratios which 
//	RRCalibrateProc has estimated. 
// 
//-------------------------------------------------------------------=72

#ifndef _RR_IA_CURVE_DATA_H
#define _RR_IA_CURVE_DATA_H

#include "RRDataSubstance.h"
#include "RRPolynomial.h"
#include "RRArray.h"

class RRIaCurveData : public RRDataSubstance
{
  private:

	RRPolynomial mIaFunc;
	RRArray< double > mExposureRatio;

  public:

    RRIaCurveData();

	static const char *getType(){return "RRIaCurveData";}

	const RRPolynomial& getIaFunc()const{return mIaFunc;}
	void setIaFunc(const RRPolynomial& func){mIaFunc=func;}

	const RRArray< double >& getExposureRatio()const{return mExposureRatio;}
	void setExposureRatio(const RRArray< double >& ratio){mExposureRatio=ratio;}

    virtual RRStatus save(FILE *fp)const;
    virtual RRStatus load(FILE *fp);

    virtual const RRDataSubstance& operator=(const RRDataSubstance& s);

    const RRIaCurveData& operator=(const RRIaCurveData& s);
	bool operator==(const RRIaCurveData& x)const;
};

#endif // _RR_IA_CURVE_DATA_H

//-------------------------------------------------------------------=72
// End of RRIaCurveData.h
//-------------------------------------------------------------------=72
