//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRIaCurveData.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Oct/31/1998:	Copied from eldIaCurveData.cpp
//
// Bugs:
//
//-------------------------------------------------------------------=72

#include "RRIaCurveData.h"

RRIaCurveData::RRIaCurveData()	
:mIaFunc(),
 mExposureRatio(0)
{}

RRStatus RRIaCurveData::save(FILE *fp)const
{
	int i;
	fprintf(fp,"Order\t%d\n",mIaFunc.getOrder());
	for(i=0;i<mIaFunc.getCoeff().getSize();i++)
		fprintf(fp,"Coeff\t%d\t%lf\n",i,mIaFunc.getCoeff()[i]);
	fprintf(fp,"NumRatios\t%d\n",mExposureRatio.getSize());
	for(i=0;i<mExposureRatio.getSize();i++)
		fprintf(fp,"ExposureRatio\t%d\t%lf\n",i,mExposureRatio[i]);
	return RR_SUCCESS;
}

RRStatus RRIaCurveData::load(FILE *fp)

{
	int i;
	
	int order;
	fscanf(fp,"Order\t%d\n",&order);
	RRArray< double > coeff(order+1);

	int n;
	for(i=0;i<coeff.getSize();i++)
		fscanf(fp,"Coeff\t%d\t%lf\n",&n,&(coeff[i]));
	mIaFunc=RRPolynomial(coeff);

	int num;
	fscanf(fp,"NumRatios\t%d\n",&num);
	mExposureRatio.setSize(num);

	for(i=0;i<mExposureRatio.getSize();i++)
		fscanf(fp,"ExposureRatio\t%d\t%lf\n",&n,&(mExposureRatio[i]));
		
	return RR_SUCCESS;
}

const RRDataSubstance& RRIaCurveData::operator=(const RRDataSubstance& s)
{
	const RRIaCurveData& ss=(const RRIaCurveData&)s;
    return (const RRDataSubstance&)operator=(ss);
}

const RRIaCurveData& RRIaCurveData::operator=(const RRIaCurveData& s)
{
	mIaFunc=s.mIaFunc;
	mExposureRatio=s.mExposureRatio;
	return *this;
}

bool RRIaCurveData::operator==(const RRIaCurveData& x)const
{
	return (mIaFunc==x.mIaFunc && 
	        mExposureRatio==mExposureRatio)?true:false;
}

//-------------------------------------------------------------------=72
// End of RRIaCurveData.cpp
//-------------------------------------------------------------------=72
