//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRGridArrayData.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/02/1998:	Copied from eldGridArrayData.h	
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
// 
//-------------------------------------------------------------------=72

#ifndef _RR_GRID_ARRAY_DATA_H
#define _RR_GRID_ARRAY_DATA_H

#include "RRDef.h"
#include "RRDataSubstance.h"
#include "RRArray.h"
#include "RRGrid2.h"

class RRGridArrayData : public RRDataSubstance
{
  private:

	RRArray< RRGrid2 > mGrid;

  public:

	RRGridArrayData();

	static const char *getType(){return "RRGridArrayData";}

	const RRArray< RRGrid2 >& getGridArray()const{return mGrid;}
	RRStatus setGridArray(const RRArray< RRGrid2 >& grid)
			{mGrid=grid; return RR_SUCCESS;}
 
    virtual RRStatus save(FILE *fp)const;
    virtual RRStatus load(FILE *fp);

    virtual const RRDataSubstance& operator=(const RRDataSubstance& s);
    const RRGridArrayData& operator=(const RRGridArrayData& s);
	
	int operator==(const RRGridArrayData& x)const;
};

#endif // _RR_GRID_ARRAY_DATA_H

//-------------------------------------------------------------------=72
// End of RRGridArrayData.h
//-------------------------------------------------------------------=72
