//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRGridArrayData.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/02/1998:	Copied from eldGridArrayData.cpp	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#include "RRGridArrayData.h"

RRGridArrayData::RRGridArrayData()	
:mGrid(0)
{}

RRStatus RRGridArrayData::save(
			FILE *fp)const
{
	fprintf(fp,"numGrids\t%d\n",mGrid.getSize());
	for(int i=0;i<mGrid.getSize();i++)
		fprintf(fp,"grid\t%d\t%d\t%d\n",
		        i,
				mGrid[i].getX(),
				mGrid[i].getY());

	return RR_SUCCESS;
}


RRStatus RRGridArrayData::
			load(FILE *fp)
{
	int n;
	fscanf(fp,"numGrids\t%d\n",&n);
	mGrid.setSize(n);

	int x,y;
	for(int i=0;i<mGrid.getSize();i++)
	{
		fscanf(fp,"grid\t%d\t%d\t%d\n",&n,&x,&y);
		mGrid[i]=RRGrid2(x,y);
	}

	return RR_SUCCESS;
}


const RRDataSubstance& RRGridArrayData::operator=(const RRDataSubstance& s)

{
	return (const RRDataSubstance&)RRGridArrayData::operator=((const RRGridArrayData&)s);
}

const RRGridArrayData& RRGridArrayData::operator=(
			const RRGridArrayData& s)
{
	mGrid=s.mGrid;
	return *this;
}

int RRGridArrayData::operator==(
			const RRGridArrayData& x)const
{
	return (mGrid==x.mGrid)?1:0;
}

//-------------------------------------------------------------------=72
// End of RRGridArrayData.cpp
//-------------------------------------------------------------------=72
