//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRFileListData.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Oct/27/1998:	Copied from eldImageArrayData.h	
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
//	RRFileListData class is a RRDataSubstance class.
//	RRFileListData is an array of RRFileName.
// 
//-------------------------------------------------------------------=72

#ifndef _RR_FILE_LIST_DATA_H
#define _RR_FILE_LIST_DATA_H

#include "RRDef.h"
#include "RRDataSubstance.h"
#include "RRArray.h"
#include "RRFileName.h"

class RRFileListData : public RRDataSubstance
{
  private:

	RRArray< RRFileName > mFileName;

  public:

    RRFileListData();
 
	static const char *getType(){return "RRFileListData";}

	int getNumFiles()const{return mFileName.getSize();}
	void setNumFiles(int n){mFileName.setSize(n);}

    const char *getFileName(int idx)const;
    RRStatus setFileName(int idx,const char *img);

    virtual RRStatus save(FILE *fp)const;
    virtual RRStatus load(FILE *fp);

    virtual const RRDataSubstance& operator=(const RRDataSubstance& s);
    const RRFileListData& operator=(const RRFileListData& s);

	bool operator==(const RRFileListData& x)const;
};

#endif // _RR_FILE_LIST_DATA_H

//-------------------------------------------------------------------=72
// End of RRFileListData.h
//-------------------------------------------------------------------=72
