//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRFileListData.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Oct/27/1998:	Copied from eldImageArrayData.cpp
//
// Bugs:
//
//-------------------------------------------------------------------=72

#include "RRFileListData.h"

#include <string.h>
#include <math.h>

RRFileListData::RRFileListData()
:mFileName()
{}
 	
const char *RRFileListData::getFileName(int idx)const
{
	if(idx>=mFileName.getSize())
		return NULL;
	else
		return &(mFileName[idx]);
}

RRStatus RRFileListData::setFileName(int idx,const char *img)
{
	if(strlen(img)>=64)
		return RR_ERROR;

	if(idx<mFileName.getSize())
	{
		mFileName[idx]=img; 
		return RR_SUCCESS;
	}
	else
		return RR_ERROR;
}

RRStatus RRFileListData::save(FILE *fp)const
{
	fprintf(fp,"numFiles\t%d\n",mFileName.getSize());
	for(int i=0;i<mFileName.getSize();i++)
		fprintf(fp,"FileName\t%d\t%s\n",i,&(mFileName[i]));
	fflush(fp);
	return RR_SUCCESS;
}

RRStatus RRFileListData::load(FILE *fp)
{
	int n;
	fscanf(fp,"numFiles\t%d\n",&n);
	mFileName.setSize(n);
	for(int i=0;i<mFileName.getSize();i++)
		fscanf(fp,"FileName\t%d\t%s\n",&n,&(mFileName[i]));
	fflush(fp);
	return RR_SUCCESS;
}

const RRDataSubstance& RRFileListData::operator=(const RRDataSubstance& s)
{
	const RRFileListData& ss=(const RRFileListData&)s;
    return (const RRDataSubstance&)operator=(ss);
}

const RRFileListData& RRFileListData::operator=(const RRFileListData& s)
{
	mFileName=s.mFileName;
    return *this;
}

bool RRFileListData::operator==(const RRFileListData& x)const
{
	return (mFileName==x.mFileName)?1:0;
}

//-------------------------------------------------------------------=72
// End of RRFileListData.cpp
//-------------------------------------------------------------------=72
