//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRDoubleFieldData.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Copied from RR2DDoubleArrayData.h	
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
//	RRDoubleFieldData class is a RRDataSubstance class.
//	RRDoubleFieldData is a field of double variables.
// 
//-------------------------------------------------------------------=72

#ifndef _RR_DOUBLE_FIELD_DATA_H
#define _RR_DOUBLE_FIELD_DATA_H

#include "RRDef.h"
#include "RRDataSubstance.h"
#include "RRField.h"

class RRDoubleFieldData : public RRDataSubstance
{
  private:

	RRField< double > mData;

  public:

	RRDoubleFieldData();

	static const char *getType(){return "RRDoubleFieldData";}

	const RRField< double >& getData()const;
	RRStatus setData(const RRField< double >& data);
 
    virtual RRStatus save(FILE *fp)const;
    virtual RRStatus load(FILE *fp);

    RRStatus saveBinary(FILE *fp)const;
    RRStatus loadBinary(FILE *fp);
	// save/load binary data. smaller.

    virtual const RRDataSubstance& operator=(const RRDataSubstance& s);
    const RRDoubleFieldData& operator=(const RRDoubleFieldData& s);
	bool operator==(const RRDoubleFieldData& x)const;
};

#endif // _RR_DOUBLE_FIELD_DATA_H

//-------------------------------------------------------------------=72
// End of RRDoubleFieldData.h
//-------------------------------------------------------------------=72
