//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRDoubleFieldData.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Copied from RR2DDoubleArrayData.cpp	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#include "RRDoubleFieldData.h"

RRDoubleFieldData::RRDoubleFieldData()	
:mData(0,0)
{}

const RRField< double >& RRDoubleFieldData::getData()const
{
	return mData;
}

RRStatus RRDoubleFieldData::setData(
			const RRField< double >& data)
{
	mData=data;
	return RR_SUCCESS;
}

RRStatus RRDoubleFieldData::save(FILE *fp)const
{
	int xs,ys;
	mData.getSize(xs,ys);
	fprintf(fp,"dimension\tx\t%d\ty\t%d\n",xs,ys);

	for(int y=0;y<ys;y++)
		for(int x=0;x<xs;x++)
			fprintf(fp,"data\t%d\t%d\t%le\n",x,y,mData.getElem(x,y));

	return RR_SUCCESS;
}

RRStatus RRDoubleFieldData::load(FILE *fp)

{
	int xs,ys;
	fscanf(fp,"dimension\tx\t%d\ty\t%d\n",&xs,&ys);
	mData.setSize(xs,ys);

	int ix,iy;
	double v;
	for(int y=0;y<ys;y++)
		for(int x=0;x<xs;x++)
		{
			fscanf(fp,"data\t%d\t%d\t%le\n",&ix,&iy,&v);
			mData.setElem(ix,iy,v);
		}

	return RR_SUCCESS;
}

RRStatus RRDoubleFieldData::saveBinary(
			FILE *fp)const
{
	int xs,ys;
	mData.getSize(xs,ys);
	fwrite(&xs,sizeof(int),1,fp);
	fwrite(&ys,sizeof(int),1,fp);

	for(int y=0;y<ys;y++)
		for(int x=0;x<xs;x++)
		{
			double v=mData.getElem(x,y);
			fwrite(&v,sizeof(double),1,fp);
		}

	return RR_SUCCESS;
}

RRStatus RRDoubleFieldData::loadBinary(
			FILE *fp)
{
	int xs,ys;
	fread(&xs,sizeof(int),1,fp);
	fread(&ys,sizeof(int),1,fp);
	mData.setSize(xs,ys);

	for(int y=0;y<ys;y++)
		for(int x=0;x<xs;x++)
		{
			double v;
			fread(&v,sizeof(double),1,fp);
			mData.setElem(x,y,v);
		}

	return RR_SUCCESS;
}

const RRDataSubstance& RRDoubleFieldData::operator=(const RRDataSubstance& s)
{
	const RRDoubleFieldData& ss=(const RRDoubleFieldData&)s;
    return (const RRDataSubstance&)operator=(ss);
}

const RRDoubleFieldData& RRDoubleFieldData::operator=(
			const RRDoubleFieldData& s)
{
	mData=s.mData;
	return *this;
}

bool RRDoubleFieldData::operator==(const RRDoubleFieldData& x)const
{
	return (mData==x.mData)?true:false;
}

//-------------------------------------------------------------------=72
// End of RRDoubleFieldData.cpp
//-------------------------------------------------------------------=72
