//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRCombineParamData.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.1
//
// Modification History:
//  Nov/21/1998:	Created	
//	Dec/15/1998:	Improved algorithms of combining and color balancing
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
//	RRCombineParamData class is a RRDataSubstance class.
//	RRCombinePaamData stores computing parameter of RRCombineProc and 
//	RRColorBalanceProc.
// 
//	double saturationLevel
//		Upper clipping level of pixel value. This must be under 1 if you 
//		want to reject saturated pixels. default value is 0.990. This 
//		parameter is used by both RRCombineProc and RRColorBalanceProc.
//
//	double noiseLevel
//		Lower clipping level of pixel value. This must be over 0 if you 
//		want to reject black-out and noisy pixels. default value is 
//		0.010. This parameter is used by both RRCombineProc and 
//		RRColorBalanceProc.
//
//	double checkIVarianceCriterion
//		Threshold value of variance of ideal pixel value. 
//		In RRCombineProc, a measured pixel value is calibrated into an 
//		ideal pixel value by applying a response curve and an exposure 
//		value. Although the ideal pixel value at a pixel position must 
//		be one, there is large variance of ideal pixel value in some 
//		pixel positions. Such large variance is mainly caused by 
//		misalignment of images. 
//		RRCombineProc changes the combining algorithm to another one 
//		when the pixel has large variance of ideal value. 
//		checkIVarianceCriterion is used as the criterion of algorithm
//		change.
//		Increase this parameter when noise at dark area in the radiance 
//		image is significant. However, increasing this parameter might
//		enhance noise at edge area. 
//		Default value is 0.0. This means that usually only one algorithm
//		is used.
//      
//	double trimRatio
//		Ratio of triming size to the original image size. Use this 
//		parameter when images have non-image area at frame. trimmed area
//		is not used at computation of color balancing scalings by 
//		RRColorBalanceProc.
//		If trimming ratio is 0.7, the size of trimmed rectangle is 70% 
//		of the original one. But the aspect ratio does not change. 
//		Default value 1. that means no trimming. 
//
//	double bestMLuminance
//		Luminace value to be selected as M values for color balancing.
//		Since there are multiple images, M values are multiple at one
//		pixel. bestMLuminance parameter is used to select one M value
//		as the best.
//		Increasing this parameter forces to select M values from 
//		brighter images. This parameter must be from 0 to 1. Default 
//		value is 0.7.
// 
//	double selectNeutralColorCriterion
//		RRColorBalanceProc computes scale factors of each channels(R,G,
//		and B) so that neutral colors in original images are invariant.
//		selectNeutralColorCriterion parameter specifies the range of 
//		neutral color. When the following equations are satisfied, the 
//		color (R,G,B) is a neutral color.
//			|R-mean(R,G,B)|/mean(R,G,B) < selectNeutralColorCriterion,
//			|G-mean(R,G,B)|/mean(R,G,B) < selectNeutralColorCriterion,
//			|B-mean(R,G,B)|/mean(R,G,B) < selectNeutralColorCriterion
//		Default value is 0.02.
// 
//-------------------------------------------------------------------=72

#ifndef _RR_COMBINE_PARAM_DATA_H
#define _RR_COMBINE_PARAM_DATA_H

#include "RRDef.h"
#include "RRDataSubstance.h"

class RRCombineParamData : public RRDataSubstance
{
  private:

	double mSaturationLevel;
	double mNoiseLevel;
	double mCheckIVarianceCriterion;
   	double mTrimRatio;
	double mBestMLuminance;
 	double mSelectNeutralColorCriterion;

  public:

    RRCombineParamData();
	// create with default values.
 
	static const char *getType(){return "RRCombineParamData";}

    virtual RRStatus save(FILE *fp)const;
    virtual RRStatus load(FILE *fp);

	double getSaturationLevel()const{return mSaturationLevel;}
	void setSaturationLevel(const double sat){mSaturationLevel=sat;}
	double getNoiseLevel()const{return mNoiseLevel;}
	void setNoiseLevel(const double noise){mNoiseLevel=noise;}
	double getCheckIVarianceCriterion()const{return mCheckIVarianceCriterion;}
	void setCheckIVarianceCriterion(const double c){mCheckIVarianceCriterion=c;}
	double getTrimRatio()const{return mTrimRatio;}
	void setTrimRatio(const double trim){mTrimRatio=trim;}
	double getBestMLuminance()const{return mBestMLuminance;}
	void setBestMLuminance(const double lum){mBestMLuminance=lum;}
	double getSelectNeutralColorCriterion()const{return mSelectNeutralColorCriterion;}
	void setSelectNeutralColorCriterion(const double s){mSelectNeutralColorCriterion=s;}

    virtual const RRDataSubstance& operator=(const RRDataSubstance& s);
    const RRCombineParamData& operator=(const RRCombineParamData& s);

	bool operator==(const RRCombineParamData& x)const;
};

#endif // _RR_COMBINE_PARAM_DATA_H

//-------------------------------------------------------------------=72
// End of RRCombineParamData.h
//-------------------------------------------------------------------=72
