//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRCombineParamData.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.1
//
// Modification History:
//  Nov/21/1998:	Created
//	Dec/15/1998:	Improved algorithms of combining and color balancing
//
// Bugs:
//
//-------------------------------------------------------------------=72

#include "RRCombineParamData.h"

#include <string.h>
#include <math.h>

const double RRCMPD_D_SATURATION_LEVEL = 0.990;
const double RRCMPD_D_NOISE_LEVEL = 0.010;
const double RRCMPD_D_CHECK_I_VARIANCE_CRITERION = 0.0;
const double RRCMPD_D_TRIM_RATIO = 1.;
const double RRCMPD_D_BEST_M_LUMINACE = 0.7;
const double RRCMPD_D_SELECT_NEUTRAL_COLOR_CRITERION = 0.02;

RRCombineParamData::RRCombineParamData()
:mSaturationLevel(RRCMPD_D_SATURATION_LEVEL),
 mNoiseLevel(RRCMPD_D_NOISE_LEVEL),
 mCheckIVarianceCriterion(RRCMPD_D_CHECK_I_VARIANCE_CRITERION),
 mTrimRatio(RRCMPD_D_TRIM_RATIO),
 mBestMLuminance(RRCMPD_D_BEST_M_LUMINACE),
 mSelectNeutralColorCriterion(RRCMPD_D_SELECT_NEUTRAL_COLOR_CRITERION)
{}
 	
RRStatus RRCombineParamData::save(FILE *fp)const
{
	fprintf(fp,"saturationLevel\t%le\n",mSaturationLevel);
	fprintf(fp,"noiseLevel\t%le\n",mNoiseLevel);
	fprintf(fp,"checkIVarianceCriterion\t%le\n",mCheckIVarianceCriterion);
	fprintf(fp,"trimRatio\t%le\n",mTrimRatio);
	fprintf(fp,"bestMLuminance\t%le\n",mBestMLuminance);
	fprintf(fp,"selectNeutralColorCriterion\t%le\n",mSelectNeutralColorCriterion);

	fflush(fp);
	return RR_SUCCESS;
}

RRStatus RRCombineParamData::load(FILE *fp)
{
	fscanf(fp,"saturationLevel\t%le\n",&mSaturationLevel);
	fscanf(fp,"noiseLevel\t%le\n",&mNoiseLevel);
	fscanf(fp,"checkIVarianceCriterion\t%le\n",&mCheckIVarianceCriterion);
	fscanf(fp,"trimRatio\t%le\n",&mTrimRatio);
	fscanf(fp,"bestMLuminance\t%le\n",&mBestMLuminance);
	fscanf(fp,"selectNeutralColorCriterion\t%le\n",&mSelectNeutralColorCriterion);

	fflush(fp);
	return RR_SUCCESS;
}

const RRDataSubstance& RRCombineParamData::operator=(const RRDataSubstance& s)
{
	const RRCombineParamData& ss=(const RRCombineParamData&)s;
    return (const RRDataSubstance&)operator=(ss);
}

const RRCombineParamData& RRCombineParamData::operator=(
			const RRCombineParamData& s)
{
	mSaturationLevel=s.mSaturationLevel;
	mNoiseLevel=s.mNoiseLevel;
	mCheckIVarianceCriterion=s.mCheckIVarianceCriterion;
   	mTrimRatio=s.mTrimRatio;
	mBestMLuminance=s.mBestMLuminance;
 	mSelectNeutralColorCriterion=s.mSelectNeutralColorCriterion;
    return *this;
}

bool RRCombineParamData::operator==(const RRCombineParamData& x)const
{
	return (mSaturationLevel==x.mSaturationLevel &&
	        mNoiseLevel==x.mNoiseLevel &&
	        mCheckIVarianceCriterion==x.mCheckIVarianceCriterion &&
        	mTrimRatio==x.mTrimRatio &&
	        mBestMLuminance==x.mBestMLuminance &&
 	        mSelectNeutralColorCriterion==x.mSelectNeutralColorCriterion)?true:false;
}

//-------------------------------------------------------------------=72
// End of RRCombineParamData.cpp
//-------------------------------------------------------------------=72
