//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRCalibrateParamData.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
// Version:              1.1
//
// Modification History:
//  Oct/31/1998:	Created	
//	Dec/16/1998:	Fixed a bug in load().
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
// The RRCalibrateParamData class is a RRDataSubstance class which 
// contains parameters for RRCalibrateProc.
// 
//-------------------------------------------------------------------=72

#ifndef _RR_CALIBRATE_PARAM_DATA_H
#define _RR_CALIBRATE_PARAM_DATA_H

#include "RRDef.h"
#include "RRDataSubstance.h"
#include "RRArray.h"

extern const int RRCPD_D_MAX_ORDER;
extern const int RRCPD_D_NUM_EXPOSURE_RATIOS;
extern const double RRCPD_D_EXPOSURE_RATIO;
extern const double RRCPD_D_CONVERGENCE_LEVEL;

class RRCalibrateParamData : public RRDataSubstance
{
  private:

	int mMaxOrder;
	RRArray< double > mExposureRatio;
	double mConvergenceLevel;

  public:

    RRCalibrateParamData();
	// create with default values.
 
    RRCalibrateParamData(
			const int maxOrder,
			const RRArray< double >& exposureRatio,
			const double convergenceLevel);

	static const char *getType(){return "RRCalibrateParamData";}

	int getMaxOrder()const{return mMaxOrder;}
	void setMaxOrder(const int order){mMaxOrder=order;}

	const RRArray< double >& getExposureRatio()const{return mExposureRatio;}
	void setExposureRatio(const RRArray< double >& ratio){mExposureRatio=ratio;}

	double getConvergenceLevel()const{return mConvergenceLevel;}
	void setConvergenceLevel(const double level){mConvergenceLevel=level;}

    virtual RRStatus save(FILE *fp)const;
    virtual RRStatus load(FILE *fp);

    virtual const RRDataSubstance& operator=(const RRDataSubstance& s);
    const RRCalibrateParamData& operator=(const RRCalibrateParamData& s);

	int operator==(const RRCalibrateParamData& x)const;
};

#endif // _RR_CALIBRATE_PARAM_DATA_H

//-------------------------------------------------------------------=72
// End of RRCalibrateParamData.h
//-------------------------------------------------------------------=72
