//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RRCalibrateParamData.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
// Version:              1.1
//
// Modification History:
//  Oct/31/1998:	Created
//	Dec/16/1998:	Fixed a bug in load().
//
// Bugs:
//
//
//-------------------------------------------------------------------=72

#include "RRCalibrateParamData.h"

#include <string.h>
#include <math.h>

const int RRCPD_D_MAX_ORDER = 5;
const int RRCPD_D_NUM_EXPOSURE_RATIOS = 4;
const double RRCPD_D_EXPOSURE_RATIO = 0.5;
const double RRCPD_D_CONVERGENCE_LEVEL = 1.e-3;

RRCalibrateParamData::RRCalibrateParamData()
:mMaxOrder(RRCPD_D_MAX_ORDER),
 mExposureRatio(RRCPD_D_NUM_EXPOSURE_RATIOS),
 mConvergenceLevel(RRCPD_D_CONVERGENCE_LEVEL)
{
	for(int i=0;i<mExposureRatio.getSize();i++)
		mExposureRatio[i]=RRCPD_D_EXPOSURE_RATIO;
}

RRCalibrateParamData::RRCalibrateParamData(
			const int maxOrder,
			const RRArray< double >& exposureRatio,
			const double convergenceLevel)
:mMaxOrder(maxOrder),
 mExposureRatio(exposureRatio),
 mConvergenceLevel(convergenceLevel)
{}
 	
RRStatus RRCalibrateParamData::save(FILE *fp)const
{
	fprintf(fp,"maxOrder\t%d\n",mMaxOrder);
	fprintf(fp,"numExposureRatios\t%d\n",mExposureRatio.getSize());
	for(int i=0;i<mExposureRatio.getSize();i++)
		fprintf(fp,"exposureRatio\t%d\t%le\n",i,mExposureRatio[i]);
	fprintf(fp,"convergenceLevel\t%le\n",mConvergenceLevel);
	fflush(fp);
	return RR_SUCCESS;
}

RRStatus RRCalibrateParamData::load(FILE *fp)
{
	fscanf(fp,"maxOrder\t%d\n",&mMaxOrder);
	int numratio;
	fscanf(fp,"numExposureRatios\t%d\n",&numratio);
	mExposureRatio.setSize(numratio);
	int n;
	for(int i=0;i<mExposureRatio.getSize();i++)
		fscanf(fp,"exposureRatio\t%d\t%le\n",&n,&(mExposureRatio[i]));
	fscanf(fp,"convergenceLevel\t%le\n",&mConvergenceLevel);
	fflush(fp);
	return RR_SUCCESS;
}

const RRDataSubstance& RRCalibrateParamData::operator=(
			const RRDataSubstance& s)
{
	const RRCalibrateParamData& ss=(const RRCalibrateParamData&)s;
    return (const RRDataSubstance&)operator=(ss);
}

const RRCalibrateParamData& RRCalibrateParamData::operator=(
			const RRCalibrateParamData& s)
{
	mMaxOrder=s.mMaxOrder;
	mExposureRatio=s.mExposureRatio;
	mConvergenceLevel=s.mConvergenceLevel;
    return *this;
}

int RRCalibrateParamData::operator==(
			const RRCalibrateParamData& x)const
{
	return (mMaxOrder==x.mMaxOrder &&
	        mExposureRatio==x.mExposureRatio &&
	        mConvergenceLevel==x.mConvergenceLevel)?1:0;
}

//-------------------------------------------------------------------=72
// End of RRCalibrateParamData.cpp
//-------------------------------------------------------------------=72
