//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RR2DDoubleArrayData.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Oct/27/1998:	Copied from eld2DDoubleArrayData.h	
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
//	RR2DDoubleArrayData class is a RRDataSubstance class.
//	RR2DDoubleArrayData is a 2-dimensional array of double variables.
// 
//-------------------------------------------------------------------=72

#ifndef _RR_2D_DOUBLE_ARRAY_DATA_H
#define _RR_2D_DOUBLE_ARRAY_DATA_H

#include "RRDef.h"
#include "RRDataSubstance.h"
#include "RRArray.h"

class RR2DDoubleArrayData : public RRDataSubstance
{
  private:

	RRArray< RRArray< double > > mData;

  public:

	RR2DDoubleArrayData();

	static const char *getType(){return "RR2DDoubleArrayData";}

	const RRArray< RRArray< double > >& getData()const;
	RRStatus setData(const RRArray< RRArray< double > >& data);
 
    virtual RRStatus save(FILE *fp)const;
    virtual RRStatus load(FILE *fp);

    virtual const RRDataSubstance& operator=(const RRDataSubstance& s);
    const RR2DDoubleArrayData& operator=(const RR2DDoubleArrayData& s);
	bool operator==(const RR2DDoubleArrayData& x)const;
};

#endif // _RR_2D_DOUBLE_ARRAY_DATA_H

//-------------------------------------------------------------------=72
// End of RR2DDoubleArrayData.h
//-------------------------------------------------------------------=72
