//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RR2DDoubleArrayData.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Oct/27/1998:	Copied from eld2DDoubleArrayData.cpp	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#include "RR2DDoubleArrayData.h"

RR2DDoubleArrayData::RR2DDoubleArrayData()	
:mData(0)
{}

const RRArray< RRArray< double > >& RR2DDoubleArrayData::getData()const
{
	return mData;
}

RRStatus RR2DDoubleArrayData::setData(
			const RRArray< RRArray< double > >& data)
{
	mData=data;
	return RR_SUCCESS;
}

 
RRStatus RR2DDoubleArrayData::save(FILE *fp)const
{
	int i;
	
	fprintf(fp,"numDataSets\t%d\n",mData.getSize());
	for(i=0;i<mData.getSize();i++)
		fprintf(fp,"numData\t%d\t%d\n",i,mData[i].getSize());
	for(i=0;i<mData.getSize();i++)
		for(int j=0;j<mData[i].getSize();j++)
			fprintf(fp,"data\t%d\t%d\t%le\n",i,j,mData[i][j]);

	return RR_SUCCESS;
}


RRStatus RR2DDoubleArrayData::load(FILE *fp)

{
	int i;
	int m,n;

	fscanf(fp,"numDataSets\t%d\n",&n);
	mData.setSize(n);
	for(i=0;i<mData.getSize();i++)
	{
		fscanf(fp,"numData\t%d\t%d\n",&n,&m);
		mData[i].setSize(m);
	}

	for(i=0;i<mData.getSize();i++)
		for(int j=0;j<mData[i].getSize();j++)
		{
			fscanf(fp,"data\t%d\t%d\t%le\n",&n,&m,&(mData[i][j]));
		}

	return RR_SUCCESS;
}

const RRDataSubstance& RR2DDoubleArrayData::operator=(const RRDataSubstance& s)
{
	const RR2DDoubleArrayData& ss=(const RR2DDoubleArrayData&)s;
    return (const RRDataSubstance&)operator=(ss);
}

const RR2DDoubleArrayData& RR2DDoubleArrayData::operator=(
			const RR2DDoubleArrayData& s)
{
	mData=s.mData;
	return *this;
}

bool RR2DDoubleArrayData::operator==(const RR2DDoubleArrayData& x)const
{
	return (mData==x.mData)?1:0;
}

//-------------------------------------------------------------------=72
// End of RR2DDoubleArrayData.cpp
//-------------------------------------------------------------------=72
