//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RVViewUserDefinePart.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#ifndef _RV_VIEW_USER_DEFINE_PART_H
#define _RV_VIEW_USER_DEFINE_PART_H

#include "WGLWindow.h"
#include "RVBitmap.h"
#include "RVFocusRectGraph.h"

class RVView;

class RVViewUserDefinePart
{
  private:

	RVView *mView;

	WGLWindow *mWglWindow;

	RVBitmap mBitmap;
	RVFocusRectGraph *mFocusRect;

	RRGrid2 mScissorBL,mScissorSize;
	RRGrid2 mPreScissorBL,mPreScissorSize;
	float mBGColor[4];

  private:

	void mfSetView(RVView *view){mView=view;}
 
  public:

	RVViewUserDefinePart();
	~RVViewUserDefinePart();	

	bool preCreateWindow(CREATESTRUCT& cs);
	void onDraw();
	bool destroyWindow();
	int onCreate(
			LPCREATESTRUCT lpCreateStruct,
			RVView *view);
	void onViewEqWhole();

	void setBitmap();
	void changeBGColor();

	RRStatus addFocusRect(RVFocusRectGraph *fr);
	RRStatus removeFocusRect(RVFocusRectGraph *fr);

	void scissorRect(RVFocusRectGraph *fr);
	void getSize(int& xs,int& ys)const;
};

#endif // _RV_VIEW_USER_DEFINE_PART_H

//-------------------------------------------------------------------=72
// End of RVViewUserDefinePart.h
//-------------------------------------------------------------------=72
