//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RVViewUserDefinePart.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#define _RV_VIEW_USER_DEFINE_PART_C

#include "stdafx.h"

#include <afxwin.h>         // MFC core and standard components

#include <gl\gl.h>
#include <gl\glu.h>

#include "RVView.h"
#include "RVViewUserDefinePart.h"

const int RVVUDP_RedrawMargin = 1;

RVViewUserDefinePart::RVViewUserDefinePart()
:mWglWindow(NULL),
 mBitmap(),
 mFocusRect(NULL)
{
	mBGColor[0]=mBGColor[1]=mBGColor[2]=mBGColor[3]=1.;
}

RVViewUserDefinePart::~RVViewUserDefinePart()	
{
	delete mWglWindow;
	// Dont delete mFocusRect. 
	// that will be deleted by RVFocusRectHandler.
}

bool RVViewUserDefinePart::preCreateWindow(
			CREATESTRUCT& cs)
{
	// Add Window styles required for OpenGL before window is created
	cs.style |= (WS_CLIPCHILDREN | WS_CLIPSIBLINGS | CS_OWNDC);
	glDisable(GL_SCISSOR_TEST);

	return true;
}

void RVViewUserDefinePart::onDraw()
{
	// Make the rendering context current
	mWglWindow->MakeCurrent();

	// Set view port
	RECT rect;
    mView->GetClientRect(&rect);
	mWglWindow->setViewport(rect);

	glScissor(mPreScissorBL.getX(),
	          mPreScissorBL.getY(),
			  mPreScissorSize.getX(),
	          mPreScissorSize.getY());

	// Clear background color
	//glClearColor(float(rand())/RAND_MAX,float(rand())/RAND_MAX,float(rand())/RAND_MAX,float(1.0));
	glClearColor(mBGColor[0],mBGColor[1],mBGColor[2],mBGColor[3]);
	glClear(GL_COLOR_BUFFER_BIT);

	// Call our external OpenGL code
	mBitmap.renderObject();
	if(mFocusRect!=NULL)
		mFocusRect->renderObject();
	
	glScissor(mScissorBL.getX(),
	          mScissorBL.getY(),
			  mScissorSize.getX(),
	          mScissorSize.getY());

	// Clear background color
	//glClearColor(float(rand())/RAND_MAX,float(rand())/RAND_MAX,float(rand())/RAND_MAX,float(1.0));
	glClearColor(mBGColor[0],mBGColor[1],mBGColor[2],mBGColor[3]);
	glClear(GL_COLOR_BUFFER_BIT);

	// Call our external OpenGL code
	mBitmap.renderObject();
	if(mFocusRect!=NULL)
		mFocusRect->renderObject();

	// Swap our scene to the front
	mWglWindow->SwapBuffers();

	// Allow other rendering contexts to co-exist
	mWglWindow->MakeCurrent();
}

bool RVViewUserDefinePart::destroyWindow()
{  
	// Clean up rendering context stuff
	delete mWglWindow;
	mWglWindow=NULL;
	return true;
}

int RVViewUserDefinePart::onCreate(
			LPCREATESTRUCT lpCreateStruct,
			RVView *view)
{
	mfSetView(view);
	mWglWindow = new WGLWindow(view->m_hWnd);
	return 0;
}
 
void RVViewUserDefinePart::onViewEqWhole()
{
	if(mBitmap.getEqualized()==true)
		mBitmap.setEqualized(false);
	else
		mBitmap.setEqualized(true);

	setBitmap();
	onDraw();
}

void RVViewUserDefinePart::setBitmap()
{
	RVDoc* pDoc = mView->GetDocument();
	ASSERT_VALID(pDoc);

	mBitmap.setBitmap(pDoc);

//	int xs,ys,depth;
//	pDoc->mUDP.getSize(xs,ys,depth);
//	::SetWindowPos(mView->m_hWnd,HWND_TOP,0,0,xs,ys,SWP_NOMOVE);
}

void RVViewUserDefinePart::changeBGColor()
{
	mBGColor[0]=float(rand())/RAND_MAX;
	mBGColor[1]=float(rand())/RAND_MAX;
	mBGColor[2]=float(rand())/RAND_MAX;
	mBGColor[3]=float(rand())/RAND_MAX;
}

void RVViewUserDefinePart::scissorRect(
			RVFocusRectGraph *fr)
{
	if(fr==NULL)
	{
		mPreScissorBL=mScissorBL=RRGrid2(0,0);
		mPreScissorSize=mScissorSize=RRGrid2(0,0);
		glDisable(GL_SCISSOR_TEST);	
	}
	else
	{
		RRBoundingBox bbox=fr->getBBox();
		mPreScissorBL=mScissorBL;
		mPreScissorSize=mScissorSize;
		mScissorBL=bbox.getBL();
		mScissorSize=bbox.getTR()-bbox.getBL();
		glEnable(GL_SCISSOR_TEST);
	}
}

RRStatus RVViewUserDefinePart::addFocusRect(
			RVFocusRectGraph *fr)
{
	mFocusRect=fr;
	return RR_SUCCESS;
}

RRStatus RVViewUserDefinePart::removeFocusRect(
			RVFocusRectGraph *fr)
{
	mFocusRect=NULL;
	return RR_SUCCESS;
}

void RVViewUserDefinePart::getSize(
			int& xs,
			int& ys)const
{
	CRect rect;
	mView->GetWindowRect(&rect);
	xs=rect.Width();
	ys=rect.Height();
}

//-------------------------------------------------------------------=72
// End of RVViewUserDefinePart.cpp
//-------------------------------------------------------------------=72
