//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RVView.cpp : implementation of the RVView class
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#include "stdafx.h"
#include "radianceView.h"

#include "RVDoc.h"
#include "RVView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// RVView

IMPLEMENT_DYNCREATE(RVView, CView)

BEGIN_MESSAGE_MAP(RVView, CView)
	//{{AFX_MSG_MAP(RVView)
	ON_WM_CREATE()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// RVView construction/destruction

RVView::RVView()
{
	// TODO: add construction code here

}

RVView::~RVView()
{
	mREH.removeFocusRect();	
	mUDP.destroyWindow();
}

BOOL RVView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	if(mUDP.preCreateWindow(cs)==false)
		return false;

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// RVView drawing

void RVView::OnDraw(CDC* pDC)
{
	RVDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here

	mUDP.onDraw();
}

/////////////////////////////////////////////////////////////////////////////
// RVView diagnostics

#ifdef _DEBUG
void RVView::AssertValid() const
{
	CView::AssertValid();
}

void RVView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

RVDoc* RVView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(RVDoc)));
	return (RVDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// RVView message handlers

int RVView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here

	mREH.setVUdp(&mUDP);
	mREH.setDUdp(&(GetDocument()->mUDP));

	int ret=mUDP.onCreate(lpCreateStruct,this);

	return ret;
}

void RVView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	mREH.onLButtonDown(this,nFlags,point);
	//CView::OnLButtonDown(nFlags, point);
}

void RVView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	mREH.onLButtonUp(this,nFlags,point);
	//CView::OnLButtonUp(nFlags, point);
}

void RVView::OnMouseMove(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	mREH.onMouseMove(this,nFlags,point);
	//CView::OnMouseMove(nFlags, point);
}

void RVView::OnViewEqWhole() 
{
	// TODO: Add your command handler code here
		HCURSOR cursor=LoadCursor(NULL,IDC_WAIT);
	HCURSOR precursor=SetCursor(cursor); 
	 
	mUDP.onViewEqWhole();	

	SetCursor(precursor); 
}

//-------------------------------------------------------------------=72
// End of RVView.cpp
//-------------------------------------------------------------------=72
