//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RVRootHandler.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#ifndef _RV_ROOT_HANDLER_H
#define _RV_ROOT_HANDLER_H

#include "WinRootHandler.h"
#include "RVViewUserDefinePart.h"
#include "RVDocUserDefinePart.h"

class RVRootHandler : public WinRootHandler
{
  private:

	RVViewUserDefinePart *mVUdp;
	RVDocUserDefinePart *mDUdp;

  protected:
  
  	virtual RRStatus mfHandleEvent(
				const RREvent& e);

	virtual RRStatus mfChangeBGColorAction();

  public:

  	RVRootHandler();
  	RVRootHandler(const RVRootHandler& x);  	
  	virtual ~RVRootHandler();
  	
	void setVUdp(RVViewUserDefinePart *vudp){mVUdp=vudp;}
	void setDUdp(RVDocUserDefinePart *dudp){mDUdp=dudp;}
	RRStatus addFocusRect();
	RRStatus removeFocusRect();

  	const RVRootHandler& operator=(const RVRootHandler& x);
};
    
#endif // _RV_ROOT_HANDLER_H

//-------------------------------------------------------------------=72
// End of RVRootHandler.h
//-------------------------------------------------------------------=72
