//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RVRootHandler.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#define _RV_ROOT_HANDLER_C

#include "stdafx.h"

#include "RVRootHandler.h"
#include "RVFocusRectHandler.h"
#include "RVFocusRect.h"

RRStatus RVRootHandler::mfHandleEvent(
				const RREvent& e)
{
	RRStatus status;
	if(e.type==RREVENT_PUSH_LBUTTON)
	{
		status=mfChangeBGColorAction();
	}
	else
	{
		status=RR_ERROR;
	}

	return status;	
}

RVRootHandler::RVRootHandler()
:WinRootHandler(),
 mVUdp(NULL),
 mDUdp(NULL)
{}

RVRootHandler::RVRootHandler(const RVRootHandler& x)
:WinRootHandler(x)
{
	setVUdp(x.mVUdp);
	setDUdp(x.mDUdp);
}
  	
RVRootHandler::~RVRootHandler()
{}
  	
const RVRootHandler& RVRootHandler::operator=(
			const RVRootHandler& x)
{
	WinRootHandler::operator=(x);
	setVUdp(x.mVUdp);
	setDUdp(x.mDUdp);
	return *this;
}
 
RRStatus RVRootHandler::mfChangeBGColorAction()
{
	mVUdp->changeBGColor();
	mVUdp->onDraw();
	return RR_SUCCESS;
}

RRStatus RVRootHandler::addFocusRect()
{
	RVFocusRect *data = new RVFocusRect(RRGrid2(100,100),RVFR_D_WIDTH);
	mDUdp->addFocusRect(data);
	
	RVFocusRectGraph *graph = new RVFocusRectGraph(data);
	mVUdp->addFocusRect(graph);
	graph->changeColorSelected();

	RVFocusRectHandler *frh = new RVFocusRectHandler(this,
													   data,
													   graph,						
													   mVUdp);
	mfSetLocking(frh);
	//mVUdp->onDraw();
	return RR_SUCCESS;
}

RRStatus RVRootHandler::removeFocusRect()
{
	int nc=mfGetNumChildren();
	if(nc<1)
		return RR_ERROR;

	RREventHandler *frh=mfGetChild(0);
	RVFocusRect *data=((RVFocusRectHandler*)frh)->getFocusRect();
	mDUdp->removeFocusRect(data);
	delete data;

	RVFocusRectGraph *graph=((RVFocusRectHandler*)frh)->getGraph();
	mVUdp->removeFocusRect(graph);
	delete graph;
			
	delete frh;

	mfSetLocking(NULL);
	//mVUdp->onDraw();
	return RR_UNLOCKED;
}

//-------------------------------------------------------------------=72
// End of RVRootHandler.cpp
//-------------------------------------------------------------------=72
