//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RVFocusRectHandler.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
// RVFocusRectHandler is a RRMobileRectHandler.
// RVFocusRectHandler is the event handler for 
// RVFocusRect.
//
//-------------------------------------------------------------------=72

#ifndef _RV_FOCUS_RECT_HANDLER_H
#define _RV_FOCUS_RECT_HANDLER_H

#include "RRDraggingPointerHandler.h"
#include "RVFocusRect.h"
#include "RVFocusRectGraph.h"
#include "RVViewUserDefinePart.h"

class RVFocusRectHandler : public RRDraggingPointerHandler
{
  private:
  
	RVFocusRectGraph *mGraph;
	// OpenGL object of FocusRect

	RVViewUserDefinePart *mView;
	// View window of RadianceView
		
	RVFocusRect *mData;
	// Data object of FocusRect

  protected:
    	
  	virtual RRStatus mfGrabbedAction(const RREvent& e);
  	// Called when this handle is grabbed.
  	
  	virtual RRStatus mfUngrabbedAction(const RREvent& e);
  	// Called when this handle is ungrabbed.
  	
  	virtual RRStatus mfDraggedAction(const RREvent& e);
  	// Called when this handle is dragged.
    	
 public:
  
  	RVFocusRectHandler(
			RREventHandler *pa,
			RVFocusRect *data,
			RVFocusRectGraph *graph,
			RVViewUserDefinePart *view);
  	// Every RVFocusRectHandler must be constructed with a certain parent.
  	 
  	RVFocusRectHandler(
			const RVFocusRectHandler& x);
  	
  	virtual ~RVFocusRectHandler();
  	
  	const RVFocusRectHandler& operator=(
			const RVFocusRectHandler& x);

	RVFocusRectGraph *getGraph()const{return mGraph;}
	RVFocusRect *getFocusRect()const{return mData;}
};
    
#endif // _RV_FOCUS_RECT_HANDLER_H

//-------------------------------------------------------------------=72
// End of RVFocusRectHandler.h
//-------------------------------------------------------------------=72
