//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RVFocusRectHandler.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#define _RV_FOCUS_RECT_HANDLER_C

#include "stdafx.h"

#include "RVFocusRectHandler.h"

const int RVFRH_SELECT_MARGIN = 1000;

RRStatus RVFocusRectHandler::mfGrabbedAction(
			const RREvent& e)
{
	RRStatus status=RRDraggingPointerHandler::mfGrabbedAction(e);
	mData->setPosition(e.pos);
	mfSetGrabbedPtr(e.pos);
	mGraph->setVisible();
	mGraph->move();
	mGraph->updateBitmap();
	mView->scissorRect(mGraph);
	mView->onDraw();
	return status;
}
  	
RRStatus RVFocusRectHandler::mfUngrabbedAction(
			const RREvent& e)
{
	RRStatus status=RRDraggingPointerHandler::mfUngrabbedAction(e);
	mGraph->setUnvisible();
	mView->scissorRect(NULL);
	mView->onDraw();
	return status;
}
  	
RRStatus RVFocusRectHandler::mfDraggedAction(
			const RREvent& e)
{
	RRStatus status=RRDraggingPointerHandler::mfDraggedAction(e);
	mData->move(e.pos-mfGetGrabbedPtr());
	mfSetGrabbedPtr(e.pos);
	mGraph->setVisible();
	mGraph->move();
	mGraph->updateBitmap();
	mView->scissorRect(mGraph);
	mView->onDraw();
	return status;
}
  
RVFocusRectHandler::RVFocusRectHandler(
			RREventHandler *pa,
			RVFocusRect *data,
			RVFocusRectGraph *graph,
			RVViewUserDefinePart *view)
:RRDraggingPointerHandler(pa,RRGrid2(),RRGrid2(),RVFRH_SELECT_MARGIN),
 mData(data),
 mGraph(graph),
 mView(view)
{
	int xs,ys;
	mView->getSize(xs,ys);

	RRBoundingBox& bbox=mfGetBBox();
	bbox=RRBoundingBox(RRGrid2(0,0),RRGrid2(xs,ys),0);
	//mData->getRectBL(),
	//                    mData->getRectTR(),
	//					RVFRH_SELECT_MARGIN);
}
  	 
RVFocusRectHandler::RVFocusRectHandler(
			const RVFocusRectHandler& x)
:RRDraggingPointerHandler(x),
 mData(x.mData),
 mGraph(x.mGraph),
 mView(x.mView)
{}
  	
RVFocusRectHandler::~RVFocusRectHandler()
{}
  	
const RVFocusRectHandler& RVFocusRectHandler::operator=(
			const RVFocusRectHandler& x)
{
	RRDraggingPointerHandler::operator=(x);
	mData=x.mData;
	mGraph=x.mGraph;
	mView=x.mView;
	return *this;
}
    
//-------------------------------------------------------------------=72
// End of RVFocusRectHandler.cpp
//-------------------------------------------------------------------=72
