//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RVFocusRectGraph.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
// RVFocusRectGraph is a WGLObject which is the graphical image
// of RVFocusRect. 
//
//-------------------------------------------------------------------=72

#ifndef _RV_FOCUS_RECT_GRAPH_H
#define _RV_FOCUS_RECT_GRAPH_H

#include "WGLObject.h"
#include "WGLBitmap.h"
#include "RVFocusRect.h"

extern const float RVFRG_SELECTED_COLOR[4];
extern const float RVFRG_UNSELECTED_COLOR[4];

class RVFocusRectGraph : public WGLObject
{
  private:

	RVFocusRect *mData; // data object of FocusRect

	WGLBitmap mBitmap;
	RRGrid2 mBL,mTR;
	float mColor[4];
	bool mVisibleFlg;

  public:

	RVFocusRectGraph(RVFocusRect *fr);
	RVFocusRectGraph(const RVFocusRectGraph& x);
	virtual ~RVFocusRectGraph();
	
	const RVFocusRectGraph& operator=(const RVFocusRectGraph& x);

	virtual bool renderObject()const;

	void setColor(const float col[]);
	void changeColorSelected();
	void changeColorUnselected();

	void move();
	// move to the position of mData
	void setVisible(){mVisibleFlg=true;}
	void setUnvisible(){mVisibleFlg=false;}
	void updateBitmap();
};

#endif // _RV_FOCUS_RECT_GRAPH_H

//-------------------------------------------------------------------=72
// End of RVFocusRectGraph.h
//-------------------------------------------------------------------=72
