//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RVFocusRectGraph.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//  Feb/27/1999:	Modified updateBitmap()
//
// Bugs:
//
//-------------------------------------------------------------------=72

#define _RV_FOCUS_RECT_GRAPH_C

#include "stdafx.h"
#include "RVFocusRectGraph.h"

const float RVFRG_SELECTED_COLOR[4] = {1.,1.,0.,1.};
const float RVFRG_UNSELECTED_COLOR[4] = {1.,1.,1.,1.};

const int RVFRG_REDRAW_MARGIN = 1;

RVFocusRectGraph::RVFocusRectGraph(
			RVFocusRect *fr)
:WGLObject(),
 mBL(fr->getRectBL()),
 mTR(fr->getRectTR()),
 mData(fr),
 mVisibleFlg(false)
{
	mfSetBBox(RRBoundingBox(mBL,mTR,RVFRG_REDRAW_MARGIN));
	mColor[0]=RVFRG_UNSELECTED_COLOR[0];
	mColor[1]=RVFRG_UNSELECTED_COLOR[1];
	mColor[2]=RVFRG_UNSELECTED_COLOR[2];
	mColor[3]=RVFRG_UNSELECTED_COLOR[3];
}

RVFocusRectGraph::RVFocusRectGraph(
			const RVFocusRectGraph& x)
:WGLObject(x),
 mBL(x.mBL),
 mTR(x.mTR),
 mData(x.mData),
 mVisibleFlg(x.mVisibleFlg)
{
	mColor[0]=x.mColor[0];
	mColor[1]=x.mColor[1];
	mColor[2]=x.mColor[2];
	mColor[3]=x.mColor[3];
}

RVFocusRectGraph::~RVFocusRectGraph()
{}

const RVFocusRectGraph& RVFocusRectGraph::operator=(
			const RVFocusRectGraph& x)
{
	WGLObject::operator=(x);
	mData=x.mData;
	mBL=x.mBL;
	mTR=x.mTR;
	mVisibleFlg=x.mVisibleFlg;
	mColor[0]=x.mColor[0];
	mColor[1]=x.mColor[1];
	mColor[2]=x.mColor[2];
	mColor[3]=x.mColor[3];
	return *this; 
}

void RVFocusRectGraph::setColor(
			const float col[])
{
	mColor[0]=col[0];
	mColor[1]=col[1];
	mColor[2]=col[2];
	mColor[3]=col[3];
}

void RVFocusRectGraph::changeColorSelected()
{
	mColor[0]=RVFRG_SELECTED_COLOR[0];
	mColor[1]=RVFRG_SELECTED_COLOR[1];
	mColor[2]=RVFRG_SELECTED_COLOR[2];
	mColor[3]=RVFRG_SELECTED_COLOR[3];
}

void RVFocusRectGraph::changeColorUnselected()
{
	mColor[0]=RVFRG_UNSELECTED_COLOR[0];
	mColor[1]=RVFRG_UNSELECTED_COLOR[1];
	mColor[2]=RVFRG_UNSELECTED_COLOR[2];
	mColor[3]=RVFRG_UNSELECTED_COLOR[3];
}

bool RVFocusRectGraph::renderObject()const
{
	if(mVisibleFlg==false)
		return false;

	if(mBitmap.renderObject()==false)
		return false;

	glPushMatrix();
	{
		glColor4fv(mColor);
		glBegin(GL_LINE_LOOP);
		glVertex2i(mBL.getX(),mBL.getY());
		glVertex2i(mTR.getX(),mBL.getY());
		glVertex2i(mTR.getX(),mTR.getY());
		glVertex2i(mBL.getX(),mTR.getY());
		glEnd();
	}
	glPopMatrix();

	return true;
}

void RVFocusRectGraph::move()
{
	mBL=mData->getRectBL();
	mTR=mData->getRectTR();
	mfSetBBox(RRBoundingBox(mBL,mTR,RVFRG_REDRAW_MARGIN));
}

void RVFocusRectGraph::updateBitmap()
{
	int w=mData->getWidth();
	int d=mData->getDepth();
	//unsigned char *bitmap = new unsigned char[w*w*d];
	RRBoundingBox bbox(mBL,mTR,0);
	if(!(bbox==mBitmap.getBBox()) ||
	   d!=mBitmap.getDepth())
		mBitmap.setDimension(bbox,d);
	unsigned char * const bitmap=mBitmap.getBitmap();

	mData->getBitmap(bitmap);
	//mBitmap=WGLBitmap(RRBoundingBox(mBL,mTR,0),d,bitmap);
	//delete[] bitmap;
}

//-------------------------------------------------------------------=72
// End of RVFocusRectGraph.cpp
//-------------------------------------------------------------------=72
