//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RVFocusRect.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72
//
// RVFocusRect is a mobile rectangle data object.
// RVFocusRect consists of the position of left-bottom corner
// (mPosition) and the width of rectangle (mWidth).
//
//-------------------------------------------------------------------=72

#ifndef _RV_FOCUS_RECT_H
#define _RV_FOCUS_RECT_H

#include "RRGrid2.h"

class RVDocUserDefinePart;

extern const int RVFR_D_WIDTH;
extern const int RVFR_D_DEPTH;
extern const int RVFR_D_SCALE;

class RVFocusRect
{
  private:

	RVDocUserDefinePart *mDoc;

	RRGrid2 mPosition; // left-bottom corner
	int mWidth;
	int mDepth;
	int mScale;

  private:

	void mfSetWidth(const int width);

  public:

	RVFocusRect();
	RVFocusRect(
			const RRGrid2& pos,
			const int width);
	RVFocusRect(
			const int px,
			const int py,
			const int width);
	RVFocusRect(const RVFocusRect& x);
	virtual ~RVFocusRect();
	
	const RVFocusRect& operator=(const RVFocusRect& x);

	void setDoc(RVDocUserDefinePart *doc){mDoc=doc;}

	RRGrid2 getPosition()const{return mPosition;}
	void getPosition(
			int& px,
			int& py)const;
	void setPosition(
			const RRGrid2& pos);
	void setPosition(
			const int px,
			const int py);

	int getWidth()const{return mWidth;}
	void setWidth(const int width);
	int getDepth()const{return mDepth;}
	int getScale()const{return mScale;}
	void setScale(const int scale){mScale=scale;}

	RRGrid2 getRectBL()const;
	RRGrid2 getRectTR()const;

	void move(const RRGrid2& dif);
	// move postion from mPostion to mPosition+dif
	RRStatus getBitmap(unsigned char *bitmap);
};

#endif // _RV_FOCUS_RECT_H

//-------------------------------------------------------------------=72
// End of RVFocusRect.h
//-------------------------------------------------------------------=72
