//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RVFocusRect.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#define _RV_FOCUS_RECT_C

#include "stdafx.h"
#include <gl\gl.h>
#include <gl\glu.h>

#include "RVFocusRect.h"
#include "RVDocUserDefinePart.H"

const int RVFR_D_WIDTH = 32;
const int RVFR_D_DEPTH = 3;
const int RVFR_D_SCALE = 1;

RVFocusRect::RVFocusRect()
:mPosition(0,0),
 mWidth(RVFR_D_WIDTH),
 mDepth(RVFR_D_DEPTH),
 mScale(RVFR_D_SCALE)
{
	mfSetWidth(RVFR_D_WIDTH);
}

RVFocusRect::RVFocusRect(
			const RRGrid2& pos,
			const int width)
:mPosition(pos),
 mWidth(width),
 mDepth(RVFR_D_DEPTH),
 mScale(RVFR_D_SCALE)
{
	mfSetWidth(width);
}

RVFocusRect::RVFocusRect(
			const int px,
			const int py,
			const int width)
:mPosition(px,py),
 mWidth(width),
 mDepth(RVFR_D_DEPTH),
 mScale(RVFR_D_SCALE)
{
	mfSetWidth(width);
}

RVFocusRect::RVFocusRect(
			const RVFocusRect& x)
:mPosition(x.mPosition),
 mWidth(x.mWidth),
 mDepth(RVFR_D_DEPTH),
 mScale(RVFR_D_SCALE)
{
	mfSetWidth(x.mWidth);
}

RVFocusRect::~RVFocusRect()
{}
	
const RVFocusRect& RVFocusRect::operator=(
			const RVFocusRect& x)
{
	mPosition=x.mPosition;
	mDepth=x.mDepth;
	mScale=x.mScale;
	mfSetWidth(x.mWidth);
	return *this;
}

void RVFocusRect::getPosition(
			int& px,
			int& py)const
{
	px=mPosition.getX();
	py=mPosition.getY();
}

void RVFocusRect::setPosition(
			const RRGrid2& pos)
{
	mPosition=pos;
}

void RVFocusRect::setPosition(
			const int px,
			const int py)
{
	mPosition=RRGrid2(px,py);
}

void RVFocusRect::mfSetWidth(
			const int width)
{
	mWidth=width;
}

void RVFocusRect::setWidth(
			const int width)
{
	mfSetWidth(width);
}

RRGrid2 RVFocusRect::getRectBL()const
{
	return mPosition+RRGrid2(-mWidth,0);
}

RRGrid2 RVFocusRect::getRectTR()const
{
	return mPosition+RRGrid2(0,mWidth);
}

void RVFocusRect::move(
			const RRGrid2& dif)
{
	mPosition.setX(mPosition.getX()+dif.getX());	
	mPosition.setY(mPosition.getY()+dif.getY());	
}

RRStatus RVFocusRect::getBitmap(unsigned char *bitmap)
{
	int width=mWidth/mScale;
	RRGrid2 center=mPosition+RRGrid2(-mWidth/2,mWidth/2);

	unsigned char *bmp = new unsigned char[width*width*mDepth];

	mDoc->getLocalRadianceBitmap(center.getX()-width/2,
	                             center.getY()-width/2,
								 width,
								 width,
								 mDepth,
								 bmp);
	if(gluScaleImage(GL_RGB,
					 width,
					 width,
					 GL_UNSIGNED_BYTE,
					 bmp,
					 mWidth,
					 mWidth,
					 GL_UNSIGNED_BYTE,
					 bitmap)!=0)
	{
		delete[] bmp;
		return RR_ERROR;
	}
	delete[] bmp;

	//RRGrid2 bl=getRectBL();
	//RRGrid2 tr=getRectTR();
	//mDoc->getLocalRadianceBitmap(bl.getX(),bl.getY(),mWidth,mWidth,mDepth,bitmap);

	return RR_SUCCESS;
}

//-------------------------------------------------------------------=72
// End of RVFocusRect.cpp
//-------------------------------------------------------------------=72
