//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// RVDocUserDefinePart.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#ifndef _RV_DOC_USER_DEFINE_PART_H
#define _RV_DOC_USER_DEFINE_PART_H

#include "RVFocusRect.h"

#include "RRImage.h"
#include "RRPixelD.h"
#include "RRFileName.h"
#include "RRField.h"

class RVDoc;

typedef enum 
{
	RV_EQUALIZING,
	RV_SCALING
} RVProcessType;

class RVDocUserDefinePart
{
  private:

	RRFileName mImage; // image file
	RRField< RRPixelD > mRadiance;

	RVFocusRect *mFocus;
	RVProcessType mProcessType;

  private:

  	bool mfGetBitmap(
			const RRImage< RRPixelB >& img,
			const int xo,
			const int yo,
			const int xs,
			const int ys,
			const int nchan,
			unsigned char *bitmap)const;

	bool mfGetLocalRadianceBitmapByEqualizing(
			const int xo,
			const int yo,
			const int xs,
			const int ys,
			const int nchan,
			unsigned char *bitmap)const;
	bool mfGetLocalRadianceBitmapByScaling(
			const int xo,
			const int yo,
			const int xs,
			const int ys,
			const int nchan,
			unsigned char *bitmap)const;

  public:

	RVDocUserDefinePart();
	~RVDocUserDefinePart();	

	bool onOpenDocument(
			LPCTSTR lpszPathName,
			const RVDoc *doc);
	void onFocusSize(
			const int size,
			const RVDoc *doc);
	void onViewmethodEqualizing(){mProcessType=RV_EQUALIZING;} 
	void onViewmethodScaling(){mProcessType=RV_SCALING;} 
	void onMagnification(
			const int mag){mFocus->setScale(mag);} 

	void getSize(
			int& xs,
			int& ys,
			int& nchan)const;

	bool getBitmap(
			const int xo,
			const int yo,
			const int xs,
			const int ys,
			const int nchan,
			unsigned char *bitmap)const;	

	bool getLocalRadianceBitmap(
			const int xo,
			const int yo,
			const int xs,
			const int ys,
			const int nchan,
			unsigned char *bitmap)const;	

	RRStatus addFocusRect(
			RVFocusRect *fr);
	RRStatus removeFocusRect(
			RVFocusRect *fr);
};

#endif // _RV_DOC_USER_DEFINE_PART_H

//-------------------------------------------------------------------=72
// End of RVDocUserDefinePart.h
//-------------------------------------------------------------------=72
